/*
 * Decompiled with CFR 0.152.
 */
package generiek.jwt;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jose.util.DefaultResourceRetriever;
import com.nimbusds.jose.util.ResourceRetriever;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import java.net.MalformedURLException;
import java.net.URL;

public class JWTValidator {
    private final ConfigurableJWTProcessor<SecurityContext> jwtProcessor = new DefaultJWTProcessor();

    public JWTValidator(String jwkSetUri, int connectTimeout, int readTimeout, int sizeLimit) throws MalformedURLException {
        DefaultResourceRetriever resourceRetriever = new DefaultResourceRetriever(connectTimeout, readTimeout, sizeLimit);
        RemoteJWKSet remoteJWKSet = new RemoteJWKSet(new URL(jwkSetUri), (ResourceRetriever)resourceRetriever);
        JWSVerificationKeySelector keySelector = new JWSVerificationKeySelector(JWSAlgorithm.RS256, (JWKSource)remoteJWKSet);
        this.jwtProcessor.setJWSKeySelector((JWSKeySelector)keySelector);
    }

    public JWTClaimsSet validate(String jwtToken) {
        return this.jwtProcessor.process(jwtToken, null);
    }
}

