/*
 * Decompiled with CFR 0.152.
 */
package generiek.api;

import com.nimbusds.jose.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class RestTemplateLoggingInterceptor
implements ClientHttpRequestInterceptor {
    private static final Log LOG = LogFactory.getLog(RestTemplateLoggingInterceptor.class);

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Start sending HttpRequest: URI:%s, Headers: (%s), Method: %s, Body: %s", request.getURI(), this.headersToString(request.getHeaders()), request.getMethod(), new String(body, Charset.defaultCharset())));
        }
        ClientHttpResponse response = execution.execute(request, body);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Received response: StatusCode:%s, Headers:%s, Body:%s", response.getStatusCode(), this.headersToString(response.getHeaders()), IOUtils.readInputStreamToString((InputStream)response.getBody())));
        }
        return response;
    }

    private String headersToString(HttpHeaders headers) {
        return headers.entrySet().stream().map(entry -> String.format("%s:%s", entry.getKey(), String.join((CharSequence)", ", (Iterable)entry.getValue()))).collect(Collectors.joining(";"));
    }
}

