/*
 * Decompiled with CFR 0.152.
 */
package generiek.model;

import generiek.model.EnrollmentRequest;
import java.io.Serializable;
import java.time.Instant;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

@Entity(name="associations")
public class Association
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="association_id")
    private String associationId;
    @Column
    private Instant created;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="enrollment_request_id")
    private EnrollmentRequest enrollmentRequest;

    public Association(String associationId, EnrollmentRequest enrollmentRequest) {
        this.associationId = associationId;
        this.enrollmentRequest = enrollmentRequest;
        this.created = Instant.now();
    }

    public Association() {
    }

    public Long getId() {
        return this.id;
    }

    public String getAssociationId() {
        return this.associationId;
    }

    public Instant getCreated() {
        return this.created;
    }

    public EnrollmentRequest getEnrollmentRequest() {
        return this.enrollmentRequest;
    }

    public String toString() {
        return "Association(id=" + this.getId() + ", associationId=" + this.getAssociationId() + ", created=" + String.valueOf(this.getCreated()) + ")";
    }
}

