/*
 * Decompiled with CFR 0.152.
 */
package generiek.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import generiek.model.Association;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import org.apache.commons.codec.binary.Base64;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Entity(name="enrollment_requests")
public class EnrollmentRequest
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column
    private String identifier;
    @Column(name="person_uri")
    private String personURI;
    @Column(name="home_institution")
    private String homeInstitution;
    @Column(name="person_auth")
    private String personAuth;
    @OneToMany(mappedBy="enrollmentRequest", orphanRemoval=true, fetch=FetchType.EAGER)
    @JsonIgnore
    private Set<Association> associations = new HashSet();
    @Column
    private String eduid;
    @Column
    private String accessToken;
    @Column
    private String refreshToken;
    @Column
    private String scope;
    @Column
    private Instant created;

    public EnrollmentRequest(EnrollmentRequest enrollmentRequest) {
        this.validate(enrollmentRequest);
        this.personURI = enrollmentRequest.personURI;
        this.personAuth = enrollmentRequest.personAuth;
        this.homeInstitution = enrollmentRequest.homeInstitution;
        this.scope = enrollmentRequest.scope;
        this.setIdentifier(UUID.randomUUID().toString());
        this.setCreated(Instant.now());
    }

    private void validate(EnrollmentRequest enrollmentRequest) {
        Assert.notNull((Object)enrollmentRequest.personURI, (String)"personURI is required");
        Assert.notNull((Object)enrollmentRequest.personAuth, (String)"personAuth is required");
        Assert.notNull((Object)enrollmentRequest.homeInstitution, (String)"homeInstitution is required");
        Assert.notNull((Object)enrollmentRequest.scope, (String)"scope is required");
    }

    public String serializeToBase64(ObjectMapper objectMapper) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("a", this.personAuth);
        result.put("h", this.homeInstitution);
        result.put("p", this.personURI);
        result.put("s", this.scope);
        byte[] bytes = objectMapper.writeValueAsBytes(result);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GZIPOutputStream gout = new GZIPOutputStream(bos);
        gout.write(bytes);
        gout.finish();
        return new String(Base64.encodeBase64((byte[])bos.toByteArray(), (boolean)false, (boolean)true));
    }

    public String toString() {
        return "EnrollmentRequest(id=" + this.getId() + ", identifier=" + this.getIdentifier() + ", personURI=" + this.getPersonURI() + ", homeInstitution=" + this.getHomeInstitution() + ", personAuth=" + this.getPersonAuth() + ", associations=" + String.valueOf(this.getAssociations()) + ", eduid=" + this.getEduid() + ", accessToken=" + StringUtils.hasText((String)this.getAccessToken()) + ", refreshToken=" + StringUtils.hasText((String)this.getRefreshToken()) + ", scope=" + this.getScope() + ", created=" + String.valueOf(this.getCreated()) + ")";
    }

    public static EnrollmentRequest serializeFromBase64(ObjectMapper objectMapper, String base64) throws IOException {
        byte[] decoded = Base64.decodeBase64((String)base64);
        if (decoded.length / 1024 >= 42) {
            throw new IllegalArgumentException("GZip bomb detected");
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(decoded);
        GZIPInputStream gin = new GZIPInputStream(bis);
        Map map = (Map)objectMapper.readValue((InputStream)gin, Map.class);
        EnrollmentRequest enrollmentRequest = new EnrollmentRequest();
        enrollmentRequest.setPersonAuth((String)map.get("a"));
        enrollmentRequest.setHomeInstitution((String)map.get("h"));
        enrollmentRequest.setPersonURI((String)map.get("p"));
        enrollmentRequest.setScope((String)map.get("s"));
        enrollmentRequest.setIdentifier(UUID.randomUUID().toString());
        enrollmentRequest.setCreated(Instant.now());
        enrollmentRequest.validate(enrollmentRequest);
        return enrollmentRequest;
    }

    public EnrollmentRequest() {
    }

    public Long getId() {
        return this.id;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getPersonURI() {
        return this.personURI;
    }

    public String getHomeInstitution() {
        return this.homeInstitution;
    }

    public String getPersonAuth() {
        return this.personAuth;
    }

    public Set<Association> getAssociations() {
        return this.associations;
    }

    public String getEduid() {
        return this.eduid;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getScope() {
        return this.scope;
    }

    public Instant getCreated() {
        return this.created;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setPersonURI(String personURI) {
        this.personURI = personURI;
    }

    public void setHomeInstitution(String homeInstitution) {
        this.homeInstitution = homeInstitution;
    }

    public void setPersonAuth(String personAuth) {
        this.personAuth = personAuth;
    }

    @JsonIgnore
    public void setAssociations(Set<Association> associations) {
        this.associations = associations;
    }

    public void setEduid(String eduid) {
        this.eduid = eduid;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setCreated(Instant created) {
        this.created = created;
    }
}

