/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.api.S3Storage;
import access.api.UserAccessRights;
import access.exception.NotFoundException;
import access.manage.Manage;
import access.model.Application;
import access.model.ApplicationMembership;
import access.model.Authority;
import access.model.Organization;
import access.model.User;
import access.repository.ApplicationRepository;
import access.repository.ConnectionRepository;
import access.repository.UserRepository;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/applications"}, produces={"application/json"})
@Transactional
@SecurityRequirements(value={@SecurityRequirement(name="openId", scopes={"openid"}), @SecurityRequirement(name="apiTokens")})
public class ApplicationController
implements UserAccessRights {
    private static final Log LOG = LogFactory.getLog(ApplicationController.class);
    private final ApplicationRepository applicationRepository;
    private final ConnectionRepository connectionRepository;
    private final Manage manage;
    private final UserRepository userRepository;
    private final S3Storage s3Storage;

    public ApplicationController(ApplicationRepository applicationRepository, ConnectionRepository connectionRepository, Manage manage, UserRepository userRepository, S3Storage s3Storage) {
        this.applicationRepository = applicationRepository;
        this.connectionRepository = connectionRepository;
        this.manage = manage;
        this.userRepository = userRepository;
        this.s3Storage = s3Storage;
    }

    @GetMapping(value={"/all/{organizationId}"})
    public ResponseEntity<List<Application>> allByOrganization(@PathVariable(value="organizationId") Long id, User user) {
        LOG.debug((Object)"/all");
        Set organizationMemberships = user.getOrganizationMemberships();
        Organization organization = organizationMemberships.stream().filter(membership -> membership.getOrganization().getId().equals(id)).map(membership -> membership.getOrganization()).findFirst().orElseThrow(() -> new NotFoundException("Organisation not found"));
        List applications = this.applicationRepository.findByOrganization(organization);
        return ResponseEntity.ok((Object)applications);
    }

    @GetMapping(value={"/{applicationId}"})
    public ResponseEntity<Application> find(User user, @PathVariable(value="applicationId") Long applicationId) {
        LOG.debug((Object)("/find application for " + user.getEmail()));
        Application application = (Application)this.applicationRepository.findDetailsById(applicationId).orElseThrow(() -> new NotFoundException("Application not found"));
        return ResponseEntity.ok((Object)application);
    }

    @PostMapping(value={"", "/"})
    public ResponseEntity<Application> create(User user, @Validated @RequestBody Application application) {
        LOG.debug((Object)("/create application by " + user.getEmail()));
        Organization organization = application.getOrganization();
        this.confirmOrganizationMembership(user, organization, Authority.MEMBER);
        application.setCreatedAt(Instant.now());
        this.applicationRepository.save((Object)application);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)application);
    }

    @PutMapping(value={"", "/"})
    public ResponseEntity<Application> update(User user, @Validated @RequestBody Application applicationData) {
        LOG.debug((Object)("/update application by " + user.getEmail()));
        Application application = (Application)this.applicationRepository.findById((Object)applicationData.getId()).orElseThrow(() -> new NotFoundException("Application not found"));
        Organization organization = application.getOrganization();
        user = this.reinitializeUser(user, this.userRepository);
        this.confirmApplicationMembership(user, organization, application, Authority.MEMBER);
        if (!application.getMetaData().equals(applicationData.getMetaData())) {
            application.getConnections().forEach(connection -> {
                Map provider = this.manage.saveProvider(connection);
                connection.updateRemoteManageData(provider);
                this.connectionRepository.save(connection);
            });
        }
        application.merge(applicationData);
        String logoUrl = application.getLogoUrl();
        if (StringUtils.hasText((String)logoUrl) && !logoUrl.startsWith("http")) {
            String url = this.s3Storage.uploadFile(logoUrl);
            application.setLogoUrl(url);
        }
        this.applicationRepository.save((Object)application);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)application);
    }

    @DeleteMapping(value={"", "/{applicationId}"})
    public ResponseEntity<Void> delete(User user, @PathVariable(value="applicationId") Long applicationId) {
        LOG.debug((Object)("/delete application by " + user.getEmail()));
        Application application = (Application)this.applicationRepository.findById((Object)applicationId).orElseThrow(() -> new NotFoundException("Application not found"));
        Organization organization = application.getOrganization();
        user = this.reinitializeUser(user, this.userRepository);
        this.confirmApplicationMembership(user, organization, application, Authority.ADMIN);
        organization.removeApplication(application);
        user.getOrganizationMemberships().forEach(organizationMembership -> {
            List<ApplicationMembership> applicationMemberships = organizationMembership.getApplicationMemberships().stream().filter(applicationMembership -> applicationMembership.getApplication().getId().equals(applicationId)).toList();
            organizationMembership.removeApplicationMemberships(applicationMemberships);
        });
        this.applicationRepository.deleteById((Object)application.getId());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).build();
    }
}

