/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.exception.NotFoundException;
import access.model.Application;
import access.model.ApplicationMembership;
import access.model.Authority;
import access.model.Organization;
import access.model.OrganizationMembership;
import access.model.User;
import access.repository.ApplicationMembershipRepository;
import access.repository.ApplicationRepository;
import access.repository.OrganizationMembershipRepository;
import access.request.ApplicationMembershipForm;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/application_memberships"}, produces={"application/json"})
@Transactional
@SecurityRequirements(value={@SecurityRequirement(name="openId", scopes={"openid"}), @SecurityRequirement(name="apiTokens")})
public class ApplicationMembershipController {
    private static final Log LOG = LogFactory.getLog(ApplicationMembershipController.class);
    private final ApplicationRepository applicationRepository;
    private final ApplicationMembershipRepository applicationMembershipRepository;
    private final OrganizationMembershipRepository organizationMembershipRepository;

    public ApplicationMembershipController(ApplicationRepository applicationRepository, ApplicationMembershipRepository applicationMembershipRepository, OrganizationMembershipRepository organizationMembershipRepository) {
        this.applicationRepository = applicationRepository;
        this.applicationMembershipRepository = applicationMembershipRepository;
        this.organizationMembershipRepository = organizationMembershipRepository;
    }

    @GetMapping(value={"/all/{applicationId}"})
    public ResponseEntity<Set<ApplicationMembership>> allByOApplication(@PathVariable(value="applicationId") Long applicationId, User user) {
        LOG.debug((Object)"/all");
        Application application = (Application)this.applicationRepository.findById((Object)applicationId).orElseThrow(() -> new NotFoundException("Application not found"));
        Organization organization = application.getOrganization();
        Set organizationMemberships = user.getOrganizationMemberships();
        boolean isMemberOfOrganization = organizationMemberships.stream().anyMatch(membership -> membership.getOrganization().getId().equals(organization.getId()));
        if (!isMemberOfOrganization) {
            throw new NotFoundException("Organization not found");
        }
        return ResponseEntity.ok((Object)application.getApplicationMemberships());
    }

    @PostMapping(value={"", "/"})
    public ResponseEntity<ApplicationMembership> create(User user, @RequestBody ApplicationMembershipForm applicationMembershipForm) {
        LOG.debug((Object)"/create");
        OrganizationMembership organizationMembership = (OrganizationMembership)this.organizationMembershipRepository.findById((Object)applicationMembershipForm.getOrganizationMembershipId()).orElseThrow(() -> new NotFoundException("OrganizationMembership not found"));
        Application application = (Application)this.applicationRepository.findById((Object)applicationMembershipForm.getApplicationId()).orElseThrow(() -> new NotFoundException("Application not found"));
        if (!application.getOrganization().getId().equals(organizationMembership.getOrganization().getId())) {
            throw new NotFoundException("Organization not found");
        }
        ApplicationMembership applicationMembership = new ApplicationMembership(application, Authority.MEMBER);
        applicationMembership = (ApplicationMembership)this.applicationMembershipRepository.save((Object)applicationMembership);
        organizationMembership.addApplicationMembership(applicationMembership);
        this.organizationMembershipRepository.save((Object)organizationMembership);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)applicationMembership);
    }
}

