/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.api.UserAccessRights;
import access.config.HashGenerator;
import access.exception.NotAllowedException;
import access.exception.NotFoundException;
import access.mail.MailBox;
import access.model.AcceptInvitation;
import access.model.Application;
import access.model.ApplicationMembership;
import access.model.Authority;
import access.model.Invitation;
import access.model.Organization;
import access.model.OrganizationMembership;
import access.model.User;
import access.repository.ApplicationRepository;
import access.repository.InvitationRepository;
import access.repository.OrganizationMembershipRepository;
import access.repository.OrganizationRepository;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/invitations"}, produces={"application/json"})
@Transactional
@SecurityRequirements(value={@SecurityRequirement(name="openId", scopes={"openid"}), @SecurityRequirement(name="apiTokens")})
public class InvitationController
implements UserAccessRights {
    private static final Log LOG = LogFactory.getLog(InvitationController.class);
    private final InvitationRepository invitationRepository;
    private final OrganizationRepository organizationRepository;
    private final OrganizationMembershipRepository organizationMembershipRepository;
    private final ApplicationRepository applicationRepository;
    private final MailBox mailBox;

    public InvitationController(InvitationRepository invitationRepository, OrganizationRepository organizationRepository, OrganizationMembershipRepository organizationMembershipRepository, ApplicationRepository applicationRepository, MailBox mailBox) {
        this.invitationRepository = invitationRepository;
        this.organizationRepository = organizationRepository;
        this.organizationMembershipRepository = organizationMembershipRepository;
        this.applicationRepository = applicationRepository;
        this.mailBox = mailBox;
    }

    @GetMapping(value={"/all/{organizationId}"})
    public ResponseEntity<List<Invitation>> byOrganization(User user, @PathVariable(value="organizationId") Long organizationId) {
        LOG.debug((Object)("/by organization by " + user.getEmail()));
        Organization organization = (Organization)this.organizationRepository.findById((Object)organizationId).orElseThrow(() -> new NotFoundException("Organization not found"));
        this.confirmOrganizationMembership(user, organization, Authority.ADMIN);
        List invitations = this.invitationRepository.findByOrganization(organization);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)invitations);
    }

    @PostMapping(value={"", "/"})
    public ResponseEntity<Invitation> create(User user, @Validated @RequestBody Invitation invitationData) {
        LOG.debug((Object)("/create invitation by " + user.getEmail()));
        Long organizationID = invitationData.getOrganization().getId();
        Organization organization = (Organization)this.organizationRepository.findById((Object)organizationID).orElseThrow(() -> new NotFoundException("Organization not found"));
        this.confirmOrganizationMembership(user, organization, Authority.ADMIN);
        Set applications = invitationData.getApplications();
        applications = applications.stream().map(application -> (Application)this.applicationRepository.findById((Object)application.getId()).orElseThrow(() -> new NotFoundException("Application not found"))).collect(Collectors.toSet());
        if (!applications.stream().allMatch(application -> application.getOrganization().getId().equals(organizationID))) {
            throw new NotAllowedException("Not allowed to add application");
        }
        Invitation invitation = new Invitation(invitationData.getLanguage(), HashGenerator.generateRandomHash(), invitationData.getEmail(), invitationData.getMessage(), invitationData.getIntendedAuthority(), organization, user, applications);
        invitation = (Invitation)this.invitationRepository.save((Object)invitation);
        this.mailBox.sendInviteMail(invitation);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)invitation);
    }

    @PutMapping(value={"/accept"})
    public ResponseEntity<OrganizationMembership> accept(User user, @Validated @RequestBody AcceptInvitation acceptInvitation) {
        LOG.debug((Object)("/accept invitation by " + user.getEmail()));
        Invitation invitation = (Invitation)this.invitationRepository.findByHash(acceptInvitation.hash()).orElseThrow(() -> new NotFoundException("Invitation not found"));
        invitation.accept();
        this.invitationRepository.save((Object)invitation);
        Organization organization = invitation.getOrganization();
        OrganizationMembership organizationMembership = new OrganizationMembership(user, organization, invitation.getIntendedAuthority());
        List<ApplicationMembership> applicationMemberships = invitation.getApplications().stream().map(application -> new ApplicationMembership(application, Authority.ADMIN)).toList();
        applicationMemberships.forEach(applicationMembership -> organizationMembership.addApplicationMembership(applicationMembership));
        organization.addOrganizationMembership(organizationMembership);
        this.organizationRepository.save((Object)organization);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)organizationMembership);
    }
}

