/*
 * Decompiled with CFR 0.152.
 */
package access.invite;

import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class InviteClient {
    private final String baseUrl;
    private final String manageIdentifier;
    private final String manageType;
    private final String clientUrl;
    private final RestTemplate restTemplate;

    public InviteClient(@Value(value="${invite.base-url}") String baseUrl, @Value(value="${invite.manage-identifier}") String manageIdentifier, @Value(value="${invite.manage-type}") String manageType, @Value(value="${config.client-url}") String clientUrl, @Value(value="${invite.user}") String userName, @Value(value="${invite.password}") String password) {
        this.baseUrl = this.removeTrailingSlash(baseUrl);
        this.manageIdentifier = manageIdentifier;
        this.manageType = manageType;
        this.clientUrl = this.removeTrailingSlash(clientUrl);
        this.restTemplate = new RestTemplate();
        this.restTemplate.getInterceptors().add(new BasicAuthenticationInterceptor(userName, password));
    }

    public Map<String, Object> createRole(String name) {
        ResponseEntity responseEntity = this.restTemplate.postForEntity(String.format("%s/api/external/v1/internal/invite/roles", this.baseUrl), (Object)this.roleTemplate(name), Map.class, new Object[0]);
        return (Map)responseEntity.getBody();
    }

    private Map<String, Object> roleTemplate(String name) {
        return Map.of("name", name, "shortName", name, "description", "Autogenerated Role for Access", "defaultExpiryDays", 1825, "inviterDisplayName", "Access", "applicationUsages", List.of(Map.of("landingPage", String.format("%s/organizations", this.clientUrl), "application", Map.of("manageId", this.manageIdentifier, "manageType", this.manageType))));
    }

    private String removeTrailingSlash(String baseUrl) {
        if (baseUrl.endsWith("/")) {
            return baseUrl.substring(0, baseUrl.length() - 1);
        }
        return baseUrl;
    }
}

