/*
 * Decompiled with CFR 0.152.
 */
package access.manage;

import access.manage.ConnectionProviderConverter;
import access.manage.JSONHeaderInterceptor;
import access.manage.Manage;
import access.manage.ManageAuthorization;
import access.manage.ResilientErrorHandler;
import access.model.Connection;
import access.model.EntityType;
import access.model.Environment;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class RemoteManage
implements Manage {
    private static final Log LOG = LogFactory.getLog(RemoteManage.class);
    private final Map<Environment, RestTemplate> restTemplates = Map.of(Environment.TEST, new RestTemplate((ClientHttpRequestFactory)new BufferingClientHttpRequestFactory((ClientHttpRequestFactory)new SimpleClientHttpRequestFactory())), Environment.PROD, new RestTemplate((ClientHttpRequestFactory)new BufferingClientHttpRequestFactory((ClientHttpRequestFactory)new SimpleClientHttpRequestFactory())));
    private final Map<String, Object> queries;
    private final ConnectionProviderConverter converter;
    private final ObjectMapper objectMapper;
    private final ManageAuthorization testAuthorization;
    private final ManageAuthorization productionAuthorization;

    public RemoteManage(ManageAuthorization testAuthorization, ManageAuthorization productionAuthorization, ConnectionProviderConverter converter, ObjectMapper objectMapper) throws IOException {
        this.testAuthorization = testAuthorization;
        this.productionAuthorization = productionAuthorization;
        this.objectMapper = objectMapper;
        this.converter = converter;
        this.queries = (Map)objectMapper.readValue(new ClassPathResource("/manage/query_templates.json").getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        ResilientErrorHandler resilientErrorHandler = new ResilientErrorHandler(objectMapper);
        this.restTemplates.forEach((arg_0, arg_1) -> RemoteManage.lambda$new$0(testAuthorization, productionAuthorization, (ResponseErrorHandler)resilientErrorHandler, arg_0, arg_1));
    }

    public List<Map<String, Object>> providers(Environment environment, EntityType ... entityTypes) {
        LOG.debug((Object)("Providers for entityTypes: " + String.valueOf(List.of(entityTypes))));
        return Stream.of(entityTypes).map(entityType -> this.getRemoteMetaData(environment, entityType.name(), false)).flatMap(Collection::stream).toList();
    }

    public Map<String, Object> providerById(Connection connection) {
        String manageIdentifier = connection.getManageIdentifier();
        EntityType protocol = connection.getProtocol();
        Environment environment = connection.getEnvironment();
        LOG.debug((Object)("providerById: " + String.valueOf(protocol)));
        String url = this.environmentUrl(environment);
        String queryUrl = String.format("%s/manage/api/internal/metadata/%s/%s", url, protocol.name(), manageIdentifier);
        RestTemplate restTemplate = this.environmentRestTemplate(environment);
        return (Map)restTemplate.getForEntity(queryUrl, Map.class, new Object[0]).getBody();
    }

    public Map<String, Object> saveProvider(Connection connection) {
        String provider = this.converter.convert(connection);
        RestTemplate restTemplate = this.environmentRestTemplate(connection.getEnvironment());
        String url = this.environmentUrl(connection.getEnvironment());
        HttpMethod httpMethod = StringUtils.hasText((String)connection.getManageIdentifier()) ? HttpMethod.PUT : HttpMethod.POST;
        ResponseEntity responseEntity = restTemplate.exchange(String.format("%s/manage/api/internal/metadata", url), httpMethod, new HttpEntity((Object)provider), Map.class, new Object[0]);
        Map body = (Map)responseEntity.getBody();
        if (ResilientErrorHandler.ignoreError((Map)body)) {
            return (Map)this.objectMapper.readValue(provider, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        return body;
    }

    public void deleteProvider(Connection connection) {
        Environment environment = connection.getEnvironment();
        RestTemplate restTemplate = this.environmentRestTemplate(environment);
        restTemplate.delete(String.format("%s/manage/api/internal/metadata/{type}/{id}", this.environmentUrl(environment)), new Object[]{connection.getProtocol(), connection.getManageIdentifier()});
    }

    public List<Map<String, Object>> providersByEntityID(Environment environment, EntityType entityType, String entityID) {
        RestTemplate restTemplate = this.environmentRestTemplate(environment);
        String url = this.environmentUrl(environment);
        String queryUrl = String.format("%s/manage/api/internal/uniqueEntityId/%s", url, entityType.name());
        return (List)restTemplate.postForEntity(queryUrl, Map.of("entityid", entityID), List.class, new Object[0]).getBody();
    }

    private List<Map<String, Object>> getRemoteMetaData(Environment environment, String type, boolean allAttributes) {
        Map baseQuery = this.getBaseQuery(allAttributes);
        String url = String.format("%s/manage/api/internal/search/%s", this.environmentUrl(environment), type);
        return (List)this.environmentRestTemplate(environment).postForObject(url, (Object)baseQuery, List.class, new Object[0]);
    }

    private Map<String, Object> getBaseQuery(boolean allAttributes) {
        HashMap<String, Object> baseQuery = new HashMap<String, Object>((Map)this.queries.get("base_query"));
        if (!allAttributes) {
            baseQuery.put("REQUESTED_ATTRIBUTES", baseQuery.get("REQUESTED_ATTRIBUTES"));
        } else {
            baseQuery.remove("REQUESTED_ATTRIBUTES");
            baseQuery.put("ALL_ATTRIBUTES", true);
        }
        return baseQuery;
    }

    private String environmentUrl(Environment environment) {
        return environment.equals((Object)Environment.TEST) ? this.testAuthorization.url() : this.productionAuthorization.url();
    }

    private RestTemplate environmentRestTemplate(Environment environment) {
        return (RestTemplate)this.restTemplates.get(environment);
    }

    private static /* synthetic */ void lambda$new$0(ManageAuthorization testAuthorization, ManageAuthorization productionAuthorization, ResponseErrorHandler resilientErrorHandler, Environment environment, RestTemplate restTemplate) {
        List interceptors = restTemplate.getInterceptors();
        ManageAuthorization authorization = environment.equals((Object)Environment.TEST) ? testAuthorization : productionAuthorization;
        interceptors.add(new BasicAuthenticationInterceptor(authorization.user(), authorization.password()));
        interceptors.add(new JSONHeaderInterceptor());
        restTemplate.setErrorHandler(resilientErrorHandler);
    }
}

