/*
 * Decompiled with CFR 0.152.
 */
package access.model;

import access.model.Application;
import access.model.Authority;
import access.model.NameHolder;
import access.model.OrganizationMembership;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.NotNull;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;

@Entity(name="application_memberships")
public class ApplicationMembership
implements NameHolder {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="application_id")
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private Application application;
    @ManyToMany(mappedBy="applicationMemberships", fetch=FetchType.LAZY, cascade={CascadeType.MERGE})
    private Set<OrganizationMembership> organizationMemberships = new HashSet();
    @Enumerated(value=EnumType.STRING)
    @Column
    @NotNull
    private Authority authority = Authority.MEMBER;

    public ApplicationMembership(Application application, Authority authority) {
        this.application = application;
        this.authority = authority;
    }

    @Transient
    @JsonIgnore
    public String getName() {
        return this.getClass().getName().concat(this.application.getName()).concat(this.authority.name());
    }

    @Generated
    public ApplicationMembership() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Application getApplication() {
        return this.application;
    }

    @Generated
    public Set<OrganizationMembership> getOrganizationMemberships() {
        return this.organizationMemberships;
    }

    @Generated
    public Authority getAuthority() {
        return this.authority;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Generated
    public void setApplication(Application application) {
        this.application = application;
    }

    @Generated
    public void setOrganizationMemberships(Set<OrganizationMembership> organizationMemberships) {
        this.organizationMemberships = organizationMemberships;
    }

    @Generated
    public void setAuthority(Authority authority) {
        this.authority = authority;
    }
}

