/*
 * Decompiled with CFR 0.152.
 */
package access.security;

import access.exception.UserRestrictionException;
import access.model.User;
import access.repository.UserRepository;
import access.security.SuperAdmin;
import jakarta.servlet.http.HttpServletRequest;
import java.security.Principal;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.core.MethodParameter;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class UserHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private final UserRepository userRepository;
    private final SuperAdmin superAdmin;

    public UserHandlerMethodArgumentResolver(UserRepository userRepository, SuperAdmin superAdmin) {
        this.userRepository = userRepository;
        this.superAdmin = superAdmin;
    }

    public boolean supportsParameter(MethodParameter methodParameter) {
        return methodParameter.getParameterType().equals(User.class);
    }

    public User resolveArgument(MethodParameter methodParameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        Map attributes;
        Principal userPrincipal = webRequest.getUserPrincipal();
        HttpServletRequest request = ((ServletWebRequest)webRequest).getRequest();
        String requestURI = request.getRequestURI();
        if (userPrincipal instanceof BearerTokenAuthentication) {
            BearerTokenAuthentication bearerTokenAuthentication = (BearerTokenAuthentication)userPrincipal;
            attributes = bearerTokenAuthentication.getTokenAttributes();
        } else if (userPrincipal instanceof OAuth2AuthenticationToken) {
            OAuth2AuthenticationToken authenticationToken = (OAuth2AuthenticationToken)userPrincipal;
            attributes = authenticationToken.getPrincipal().getAttributes();
        } else {
            if (requestURI.equals("/api/v1/users/config")) {
                return null;
            }
            throw new UserRestrictionException("Forbidden");
        }
        String sub = attributes.get("sub").toString();
        AtomicBoolean validImpersonation = new AtomicBoolean(false);
        Optional<User> optionalUser = this.userRepository.findBySubIgnoreCase(sub).or(() -> this.superAdmin.getUsers().stream().filter(adminSub -> adminSub.equals(sub)).findFirst().map(adminSub -> (User)this.userRepository.save((Object)new User(true, attributes)))).or(() -> {
            User user = new User(attributes);
            this.userRepository.save((Object)user);
            return Optional.of(user);
        }).map(user -> {
            String impersonateId = webRequest.getHeader("X-IMPERSONATE-ID");
            if (StringUtils.hasText((String)impersonateId) && user.isSuperUser()) {
                validImpersonation.set(true);
                return (User)this.userRepository.findById((Object)Long.valueOf(impersonateId)).orElseThrow(UserRestrictionException::new);
            }
            return user;
        });
        return optionalUser.orElseThrow(UserRestrictionException::new);
    }
}

