/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.exception.NotFoundException;
import access.exception.RemoteException;
import access.exception.UserRestrictionException;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;

@RestController
@Hidden
public class DefaultErrorController
implements ErrorController {
    private static final Log LOG = LogFactory.getLog(DefaultErrorController.class);
    private final ErrorAttributes errorAttributes;

    @Autowired
    public DefaultErrorController(ErrorAttributes errorAttributes) {
        this.errorAttributes = errorAttributes;
    }

    @RequestMapping(value={"/error"})
    public ResponseEntity<Map<String, Object>> error(HttpServletRequest request) {
        HttpStatus statusCode;
        ServletWebRequest webRequest = new ServletWebRequest(request);
        Map result = this.errorAttributes.getErrorAttributes((WebRequest)webRequest, ErrorAttributeOptions.of((ErrorAttributeOptions.Include[])new ErrorAttributeOptions.Include[]{ErrorAttributeOptions.Include.EXCEPTION, ErrorAttributeOptions.Include.MESSAGE, ErrorAttributeOptions.Include.BINDING_ERRORS}));
        Throwable error = this.errorAttributes.getError((WebRequest)webRequest);
        if (error == null) {
            statusCode = result.containsKey("message") && ((String)result.get("message")).equalsIgnoreCase("forbidden") ? HttpStatus.FORBIDDEN : (result.containsKey("status") && (Integer)result.get("status") != 999 ? HttpStatus.valueOf((int)((Integer)result.get("status"))) : HttpStatus.INTERNAL_SERVER_ERROR);
        } else {
            ResponseStatus annotation;
            if (!(error instanceof NotFoundException)) {
                boolean logStackTrace = !(error instanceof UserRestrictionException) && !(error instanceof RemoteException);
                LOG.error((Object)String.format("Error occurred; %s", error), logStackTrace ? error : null);
            }
            statusCode = error instanceof AccessDeniedException ? HttpStatus.FORBIDDEN : ((annotation = (ResponseStatus)AnnotationUtils.getAnnotation(error.getClass(), ResponseStatus.class)) != null ? annotation.value() : HttpStatus.BAD_REQUEST);
        }
        result.put("status", statusCode.value());
        return ResponseEntity.status((HttpStatusCode)statusCode).body((Object)result);
    }
}

