/*
 * Decompiled with CFR 0.152.
 */
package access.manage;

import access.model.Application;
import access.model.Connection;
import access.model.EntityType;
import access.model.Environment;
import access.model.State;
import access.model.Visibility;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.StringUtils;

public class ConnectionProviderConverter {
    private final ObjectMapper objectMapper;
    private final List<Map<String, Object>> privacyInfo;
    private final State defaultTestState;
    private final State defaultProdState;

    public ConnectionProviderConverter(ObjectMapper objectMapper, State defaultTestState, State defaultProdState) {
        this.defaultTestState = defaultTestState;
        this.defaultProdState = defaultProdState;
        this.objectMapper = objectMapper;
        this.privacyInfo = (List)objectMapper.readValue(new ClassPathResource("/metadata/Privacy.json").getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    public String convert(Connection connection) throws JsonProcessingException {
        Application application = connection.getApplication();
        Map connectionMetaData = connection.getMetaData();
        Map applicationMetaData = application.getMetaData();
        Map information = applicationMetaData.getOrDefault("information", Map.of());
        HashMap result = new HashMap();
        HashMap<String, Object> data = new HashMap<String, Object>();
        HashMap<String, Object> metaDataFields = new HashMap<String, Object>();
        data.put("metaDataFields", metaDataFields);
        result.put("data", data);
        this.putIf(result, "id", (Object)connection.getManageIdentifier());
        this.putIf(result, "version", (Object)connection.getManageVersion());
        result.put("type", connection.getProtocol());
        this.putIf(result, "eid", (Object)connection.getManageEid());
        data.put("entityid", connectionMetaData.get("entityID"));
        data.put("state", connection.getEnvironment().equals((Object)Environment.TEST) ? this.defaultTestState : this.defaultProdState);
        data.put("allowedall", false);
        this.putIf(data, "arp", connectionMetaData.get("arp"));
        List allowedEntities = connectionMetaData.getOrDefault("allowedEntities", List.of());
        data.put("allowedEntities", allowedEntities.stream().map(entity -> Map.of("name", entity)).toList());
        metaDataFields.put("name:en", connection.getName());
        metaDataFields.put("name:nl", connection.getName());
        this.putIf(metaDataFields, "logo:0:url", (Object)application.getLogoUrl());
        this.putIf(metaDataFields, "description:en", information.get("descriptionEN"));
        this.putIf(metaDataFields, "description:nl", information.get("descriptionNL"));
        this.putIf(metaDataFields, "coin:application_url", information.get("webSite"));
        List tags = information.getOrDefault("tags", List.of());
        this.putIf(metaDataFields, "coin:ss:type_of_service:en", (Object)String.join((CharSequence)" ", tags));
        this.putIf(metaDataFields, "coin:ss:type_of_service:nl", (Object)String.join((CharSequence)" ", tags));
        if (EntityType.oidc10_rp.equals((Object)connection.getProtocol())) {
            List grantTypes = (List)connectionMetaData.get("grantTypes");
            this.putIf(metaDataFields, "grants", (Object)grantTypes);
            this.putIf(metaDataFields, "redirectUrls", connectionMetaData.get("redirectUrls"));
            metaDataFields.put("isPublicClient", connectionMetaData.getOrDefault("pkce", false));
            metaDataFields.put("accessTokenValidity", 3600);
            if (grantTypes.contains("refresh_token")) {
                metaDataFields.put("refreshTokenValidity", 3600);
            }
            this.putIf(metaDataFields, "secret", connectionMetaData.get("secret"));
        }
        if (EntityType.saml20_sp.equals((Object)connection.getProtocol())) {
            List acsLocations = connectionMetaData.getOrDefault("acsLocations", Collections.emptyList());
            IntStream.range(0, acsLocations.size()).forEach(i -> {
                metaDataFields.put("AssertionConsumerService:" + i + ":Location", acsLocations.get(i));
                metaDataFields.put("AssertionConsumerService:" + i + ":Binding", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            });
        }
        String visibility = (String)connectionMetaData.get("visibility");
        metaDataFields.put("coin:ss:idp_visible_only", Visibility.visible_to_idp_only.name().equals(visibility));
        metaDataFields.put("coin:ss:hidden", Visibility.visible_to_none.name().equals(visibility));
        List contactPersons = applicationMetaData.getOrDefault("contactPersons", Collections.emptyList());
        IntStream.range(0, contactPersons.size()).forEach(i -> {
            Map contactPerson = (Map)contactPersons.get(i);
            Map.of("type", "contactType", "email", "emailAddress", "givenName", "givenName", "surName", "surName").forEach((k, v) -> this.putIf(metaDataFields, "contacts:" + i + ":" + v, contactPerson.get(k)));
        });
        Map privacy = applicationMetaData.getOrDefault("privacy", Map.of());
        this.privacyInfo.forEach(item -> this.putIf(metaDataFields, (String)item.get("manage"), privacy.get(item.get("name"))));
        metaDataFields.put("OrganizationName:en", application.getOrganization().getName());
        return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(result);
    }

    private void putIf(Map<String, Object> result, String key, Object value) {
        if (value instanceof String && StringUtils.hasText((String)((String)value)) || value != null) {
            result.put(key, value);
        }
    }
}

