/*
 * Decompiled with CFR 0.152.
 */
package access.security;

import access.repository.UserRepository;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;

public class CustomOidcUserService
implements OAuth2UserService<OidcUserRequest, OidcUser> {
    private static final Log LOG = LogFactory.getLog(CustomOidcUserService.class);
    private final UserRepository userRepository;
    private final OidcUserService delegate;

    public CustomOidcUserService(UserRepository userRepository) {
        this.userRepository = userRepository;
        this.delegate = new OidcUserService();
    }

    public OidcUser loadUser(OidcUserRequest userRequest) throws OAuth2AuthenticationException {
        OidcUser oidcUser = this.delegate.loadUser(userRequest);
        Map claims = oidcUser.getUserInfo().getClaims();
        HashMap newClaims = new HashMap(claims);
        String sub = (String)newClaims.get("sub");
        Optional optionalUser = this.userRepository.findBySubIgnoreCase(sub);
        optionalUser.ifPresent(user -> {
            boolean changed = user.updateAttributes(newClaims);
            if (changed) {
                LOG.debug((Object)("Updating user with new attributes: " + String.valueOf(newClaims)));
                this.userRepository.save(user);
            }
        });
        OidcUserInfo oidcUserInfo = new OidcUserInfo(newClaims);
        oidcUser = new DefaultOidcUser(oidcUser.getAuthorities(), oidcUser.getIdToken(), oidcUserInfo);
        return oidcUser;
    }

    @Generated
    public UserRepository getUserRepository() {
        return this.userRepository;
    }
}

