/*
 * Decompiled with CFR 0.152.
 */
package access.model;

import access.model.Application;
import access.model.Authority;
import access.model.InvitationStatus;
import access.model.Language;
import access.model.Organization;
import access.model.User;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.validation.constraints.NotNull;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Entity(name="invitations")
public class Invitation {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Enumerated(value=EnumType.STRING)
    @NotNull
    private Language language;
    @Enumerated(value=EnumType.STRING)
    private InvitationStatus status = InvitationStatus.OPEN;
    @Column
    private String hash;
    @Column
    @NotNull
    private String email;
    @Column
    private String message;
    @Column(name="created_at")
    private Instant createdAt;
    @Column(name="expiry_date")
    private Instant expiryDate;
    @Column(name="accepted_at")
    private Instant acceptedAt;
    @Enumerated(value=EnumType.STRING)
    @Column(name="intended_authority")
    @NotNull
    private Authority intendedAuthority = Authority.MEMBER;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="organization_id")
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private Organization organization;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="invitee_id")
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private User invitee;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.MERGE})
    @JoinTable(name="invitations_applications", joinColumns={@JoinColumn(name="invitation_id")}, inverseJoinColumns={@JoinColumn(name="application_id")})
    private Set<Application> applications = new HashSet();

    public Invitation(Language language, String hash, String email, String message, Authority intendedAuthority, Organization organization, User invitee, Set<Application> applications) {
        this.language = language;
        this.hash = hash;
        this.email = email;
        this.message = message;
        this.intendedAuthority = intendedAuthority;
        this.organization = organization;
        this.invitee = invitee;
        this.applications = applications;
        this.createdAt = Instant.now();
        this.expiryDate = this.createdAt.plus(30L, ChronoUnit.DAYS);
    }

    @JsonIgnore
    public List<String> anyApplications() {
        return CollectionUtils.isEmpty((Collection)this.applications) ? Collections.emptyList() : Arrays.asList("will-iterate-once");
    }

    @JsonProperty(value="inviter", access=JsonProperty.Access.READ_ONLY)
    public Map<String, Object> getInviterEmail() {
        User inviter = this.getInvitee();
        HashMap<String, Object> info = new HashMap<String, Object>();
        if (inviter != null) {
            info.put("email", inviter.getEmail());
            info.put("name", StringUtils.hasText((String)inviter.getName()) ? inviter.getName() : inviter.getEmail());
            info.put("user_id", inviter.getId());
        }
        return info;
    }

    @JsonIgnore
    public void accept() {
        this.status = InvitationStatus.ACCEPTED;
        this.hash = null;
        this.acceptedAt = Instant.now();
    }

    @Generated
    public Invitation() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Language getLanguage() {
        return this.language;
    }

    @Generated
    public InvitationStatus getStatus() {
        return this.status;
    }

    @Generated
    public String getHash() {
        return this.hash;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Instant getExpiryDate() {
        return this.expiryDate;
    }

    @Generated
    public Instant getAcceptedAt() {
        return this.acceptedAt;
    }

    @Generated
    public Authority getIntendedAuthority() {
        return this.intendedAuthority;
    }

    @Generated
    public Organization getOrganization() {
        return this.organization;
    }

    @Generated
    public User getInvitee() {
        return this.invitee;
    }

    @Generated
    public Set<Application> getApplications() {
        return this.applications;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setLanguage(Language language) {
        this.language = language;
    }

    @Generated
    public void setStatus(InvitationStatus status) {
        this.status = status;
    }

    @Generated
    public void setHash(String hash) {
        this.hash = hash;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setExpiryDate(Instant expiryDate) {
        this.expiryDate = expiryDate;
    }

    @Generated
    public void setAcceptedAt(Instant acceptedAt) {
        this.acceptedAt = acceptedAt;
    }

    @Generated
    public void setIntendedAuthority(Authority intendedAuthority) {
        this.intendedAuthority = intendedAuthority;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Generated
    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Generated
    public void setInvitee(User invitee) {
        this.invitee = invitee;
    }

    @Generated
    public void setApplications(Set<Application> applications) {
        this.applications = applications;
    }
}

