/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.api.Results;
import access.api.UserAccessRights;
import access.exception.InvalidInputException;
import access.exception.NotFoundException;
import access.jira.JiraClient;
import access.jira.JiraIssue;
import access.manage.ChangeRequest;
import access.manage.Manage;
import access.manage.PathUpdateType;
import access.model.Application;
import access.model.Authority;
import access.model.Connection;
import access.model.ConnectionStatus;
import access.model.EntityType;
import access.model.Organization;
import access.model.User;
import access.repository.ApplicationRepository;
import access.repository.ConnectionRepository;
import access.repository.UserRepository;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.passay.CharacterData;
import org.passay.CharacterRule;
import org.passay.EnglishCharacterData;
import org.passay.PasswordGenerator;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/connections"}, produces={"application/json"})
@Transactional
@SecurityRequirements(value={@SecurityRequirement(name="openId", scopes={"openid"}), @SecurityRequirement(name="apiTokens")})
public class ConnectionController
implements UserAccessRights {
    private static final Log LOG = LogFactory.getLog(ConnectionController.class);
    private final ConnectionRepository connectionRepository;
    private final ApplicationRepository applicationRepository;
    private final UserRepository userRepository;
    private final Manage manage;
    private final JiraClient jiraClient;
    private final PasswordGenerator passwordGenerator = new PasswordGenerator();
    private final List<CharacterRule> rules = this.initPasswordGeneratorRules();

    public ConnectionController(ConnectionRepository connectionRepository, ApplicationRepository applicationRepository, UserRepository userRepository, Manage manage, JiraClient jiraClient) {
        this.connectionRepository = connectionRepository;
        this.applicationRepository = applicationRepository;
        this.userRepository = userRepository;
        this.manage = manage;
        this.jiraClient = jiraClient;
    }

    private List<CharacterRule> initPasswordGeneratorRules() {
        return List.of(new CharacterRule((CharacterData)EnglishCharacterData.LowerCase, 8), new CharacterRule((CharacterData)EnglishCharacterData.UpperCase, 8), new CharacterRule((CharacterData)EnglishCharacterData.Digit, 8));
    }

    @GetMapping(value={"/{connectionId}"})
    public ResponseEntity<Connection> find(User user, @PathVariable(value="connectionId") Long connectionId) {
        LOG.debug((Object)("/find connection for " + user.getEmail()));
        Connection connection = (Connection)this.connectionRepository.findById((Object)connectionId).orElseThrow(() -> new NotFoundException("Connection not found"));
        Map provider = this.manage.providerById(connection);
        if (connection.mergeMetaData(provider)) {
            this.connectionRepository.save((Object)connection);
        }
        return ResponseEntity.ok((Object)connection);
    }

    @PostMapping(value={"", "/"})
    public ResponseEntity<Connection> create(User user, @Validated @RequestBody Connection connection) {
        LOG.debug((Object)("/create connection by " + user.getEmail()));
        if (!connection.isValid()) {
            throw new InvalidInputException("Connection is not valid");
        }
        Long applicationID = connection.getApplication().getId();
        Application application = (Application)this.applicationRepository.findById((Object)applicationID).orElseThrow(() -> new NotFoundException("Application not found"));
        user = this.reinitializeUser(user, this.userRepository);
        this.confirmApplicationMembership(user, application.getOrganization(), application, Authority.MEMBER);
        connection.setCreatedAt(Instant.now());
        connection.setApplication(application);
        connection = this.saveConnection(connection);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)connection);
    }

    @PutMapping(value={"", "/"})
    public ResponseEntity<Connection> update(User user, @Validated @RequestBody Connection connectionData) {
        LOG.debug((Object)("/update connection by " + user.getEmail()));
        if (!connectionData.isValid()) {
            throw new InvalidInputException("Connection is not valid");
        }
        Connection connection = (Connection)this.connectionRepository.findById((Object)connectionData.getId()).orElseThrow(() -> new NotFoundException("Connection not found"));
        Application application = connection.getApplication();
        Organization organization = application.getOrganization();
        user = this.reinitializeUser(user, this.userRepository);
        this.confirmApplicationMembership(user, organization, application, Authority.MEMBER);
        connection.merge(connectionData);
        connection = this.saveConnection(connection);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)connection);
    }

    @PutMapping(value={"/reset-secret/{connectionId}"}, produces={"application/json"})
    public Map<String, String> secret(User user, @PathVariable(value="connectionId") Long connectionId) {
        Connection connection = (Connection)this.connectionRepository.findById((Object)connectionId).orElseThrow(() -> new NotFoundException("Connection not found"));
        Application application = connection.getApplication();
        Organization organization = application.getOrganization();
        user = this.reinitializeUser(user, this.userRepository);
        this.confirmApplicationMembership(user, organization, application, Authority.MEMBER);
        String secret = this.passwordGenerator.generatePassword(36, this.rules);
        connection.getMetaData().put("secret", secret);
        this.saveConnection(connection);
        return Collections.singletonMap("secret", secret);
    }

    @PutMapping(value={"/request-production-status/{connectionId}"}, produces={"application/json"})
    public ResponseEntity<Map<String, Object>> requestProductionStatus(User user, @PathVariable(value="connectionId") Long connectionId) {
        Connection connection = (Connection)this.connectionRepository.findById((Object)connectionId).orElseThrow(() -> new NotFoundException("Connection not found"));
        Application application = connection.getApplication();
        Organization organization = application.getOrganization();
        user = this.reinitializeUser(user, this.userRepository);
        this.confirmApplicationMembership(user, organization, application, Authority.MEMBER);
        String changeRequestURL = this.manage.changeRequestURL(connection.getEnvironment(), connection);
        Map provider = this.manage.providerById(connection);
        String entityId = (String)((Map)provider.get("data")).get("entityid");
        String lineSeparator = System.lineSeparator();
        String jiraKey = this.jiraClient.create(new JiraIssue(entityId, String.format("Production status requested by %s for %s.", user.getName(), connection.getName()), String.format("A change request in manage has been created to merge this user request. See:%s%s", lineSeparator, changeRequestURL), connection.getProtocol(), user.getEmail()));
        ChangeRequest changeRequest = new ChangeRequest(connection.getManageIdentifier(), connection.getProtocol(), Map.of("state", "prodaccepted"), Map.of("user", user.getEmail(), "notes", String.format("Production status requested by %s for %s. See Jira %s", user.getName(), connection.getName(), jiraKey)), false, PathUpdateType.ADDITION);
        Map changeRequestResponse = this.manage.createChangeRequest(connection.getEnvironment(), changeRequest);
        LOG.debug((Object)("Change request response from manage: " + String.valueOf(changeRequestResponse)));
        connection.setStatus(ConnectionStatus.PENDING_PROD);
        this.saveConnection(connection);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body(Map.of("status", HttpStatus.CREATED.value(), "jiraKey", jiraKey));
    }

    @DeleteMapping(value={"", "/{connectionId}"})
    public ResponseEntity<Map<String, Integer>> delete(User user, @PathVariable(value="connectionId") Long connectionId) {
        LOG.debug((Object)("/delete connection by " + user.getEmail()));
        Connection connection = (Connection)this.connectionRepository.findById((Object)connectionId).orElseThrow(() -> new NotFoundException("Connection not found"));
        Application application = connection.getApplication();
        Organization organization = application.getOrganization();
        user = this.reinitializeUser(user, this.userRepository);
        this.confirmApplicationMembership(user, organization, application, Authority.MEMBER);
        if (StringUtils.hasText((String)connection.getManageIdentifier())) {
            this.manage.deleteProvider(connection);
        }
        application.removeConnection(connection);
        this.connectionRepository.deleteById((Object)connectionId);
        return Results.deleteResult();
    }

    private Connection saveConnection(Connection connection) {
        if (!connection.getStatus().equals((Object)ConnectionStatus.OPEN)) {
            if (connection.getProtocol().equals((Object)EntityType.oidc10_rp) && !StringUtils.hasText((String)((String)connection.getMetaData().get("secret"))) && connection.getMetaData().getOrDefault("pkce", false) == Boolean.FALSE) {
                String secret = this.passwordGenerator.generatePassword(36, this.rules);
                connection.getMetaData().put("secret", secret);
            }
            Map provider = this.manage.saveProvider(connection);
            connection.updateRemoteManageData(provider);
            List contactPersons = (List)connection.getMetaData().get("contactPersons");
            if (!CollectionUtils.isEmpty((Collection)contactPersons)) {
                Application application = connection.getApplication();
                application.getMetaData().put("contactPersons", contactPersons);
                this.applicationRepository.save((Object)application);
                connection.getMetaData().remove("contactPersons");
            }
        }
        return (Connection)this.connectionRepository.save((Object)connection);
    }
}

