/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.auth.signer.AwsS3V4Signer;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.PutBucketPolicyRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

@Service
public class S3Storage {
    private final String bucketName;
    private final String s3URL;
    private final ObjectMapper objectMapper;
    private final S3Client s3Client;
    private final Map<String, String> metadata = Map.of("Cache-Control", "max-age=31536000, public");
    private boolean bucketExists;

    public S3Storage(@Value(value="${s3storage.url}") String s3URL, @Value(value="${s3storage.key}") String s3AccessKey, @Value(value="${s3storage.secret}") String s3SecretKey, @Value(value="${s3storage.bucket}") String s3BucketName, ObjectMapper objectMapper) {
        this.s3URL = s3URL;
        AwsBasicCredentials credentials = AwsBasicCredentials.create((String)s3AccessKey, (String)s3SecretKey);
        this.s3Client = (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().endpointOverride(new URI(s3URL))).region(Region.EU_CENTRAL_1)).forcePathStyle(Boolean.valueOf(true))).overrideConfiguration(c -> c.putAdvancedOption(SdkAdvancedClientOption.SIGNER, (Object)AwsS3V4Signer.create()))).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)credentials))).build();
        this.bucketName = s3BucketName;
        this.objectMapper = objectMapper;
    }

    public String uploadFile(String content) {
        byte[] decodedBytes = Base64.getDecoder().decode(content);
        if (!this.bucketExists) {
            this.createBucket(this.s3Client);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(decodedBytes);
        String uuid = UUID.randomUUID().toString();
        this.s3Client.putObject((PutObjectRequest)PutObjectRequest.builder().bucket(this.bucketName).key(uuid).contentType("image/jpeg").metadata(this.metadata).build(), RequestBody.fromInputStream((InputStream)inputStream, (long)inputStream.available()));
        return String.format("%s/%s/%s", this.s3URL, this.bucketName, uuid);
    }

    private void createBucket(S3Client s3Client) {
        HeadBucketRequest headBucketRequest = (HeadBucketRequest)HeadBucketRequest.builder().bucket(this.bucketName).build();
        try {
            s3Client.headBucket(headBucketRequest);
        }
        catch (NoSuchBucketException e) {
            s3Client.createBucket((CreateBucketRequest)CreateBucketRequest.builder().bucket(this.bucketName).build());
            PutBucketPolicyRequest putBucketPolicyRequest = (PutBucketPolicyRequest)PutBucketPolicyRequest.builder().bucket(this.bucketName).policy(this.getPublicBucketPolicy(this.bucketName)).build();
            s3Client.putBucketPolicy(putBucketPolicyRequest);
            this.bucketExists = true;
        }
    }

    private String getPublicBucketPolicy(String bucketName) {
        return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(Map.of("Version", "2012-10-17", "Statement", List.of(Map.of("Effect", "Allow", "Principal", Map.of("AWS", "*"), "Action", "s3:GetObject", "Resource", String.format("arn:aws:s3:::%s/*", bucketName)))));
    }
}

