/*
 * Decompiled with CFR 0.152.
 */
package access.model;

import access.manage.Contact;
import access.model.Application;
import access.model.ConnectOptions;
import access.model.ConnectionStatus;
import access.model.EntityType;
import access.model.Environment;
import access.model.NameHolder;
import access.model.State;
import access.model.Visibility;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.hypersistence.utils.hibernate.type.json.JsonType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.validation.constraints.NotNull;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import lombok.Generated;
import org.hibernate.annotations.Type;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Entity(name="connections")
public class Connection
implements NameHolder {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column
    @NotNull
    private String name;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="application_id")
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private Application application;
    @Type(value=JsonType.class)
    @Column(name="meta_data", columnDefinition="jsonb")
    private Map<String, Object> metaData = new HashMap();
    @Enumerated(value=EnumType.STRING)
    @Column
    @NotNull
    private EntityType protocol = EntityType.oidc10_rp;
    @Enumerated(value=EnumType.STRING)
    @Column
    @NotNull
    private Environment environment = Environment.TEST;
    @Enumerated(value=EnumType.STRING)
    @Column
    @NotNull
    private State state = State.prodaccepted;
    @Enumerated(value=EnumType.STRING)
    @Column
    @NotNull
    private ConnectionStatus status = ConnectionStatus.OPEN;
    @Column(name="manage_identifier")
    private String manageIdentifier;
    @Column(name="manage_version")
    private Integer manageVersion;
    @Column(name="manage_eid")
    private Integer manageEid;
    @Column(name="created_at")
    private Instant createdAt;

    public Connection(String name, Application application, Map<String, Object> metaData, EntityType protocol, Environment environment) {
        this.name = name;
        this.application = application;
        this.metaData = metaData;
        this.protocol = protocol;
        this.environment = environment;
        this.createdAt = Instant.now();
        this.manageVersion = 0;
    }

    @JsonIgnore
    public boolean isValid() {
        if (!StringUtils.hasText((String)this.name)) {
            return false;
        }
        String entityID = (String)this.metaData.get("entityID");
        if (!StringUtils.hasText((String)entityID) && EntityType.saml20_sp.equals((Object)this.protocol)) {
            return false;
        }
        String protocolName = this.protocol.name();
        if (protocolName.equals("OIDC") && (CollectionUtils.isEmpty((Collection)((Collection)this.metaData.get("redirectUrls"))) || CollectionUtils.isEmpty((Collection)((Collection)this.metaData.get("grantTypes"))))) {
            return false;
        }
        return !protocolName.equals("SAML") || !CollectionUtils.isEmpty((Collection)((Collection)this.metaData.get("acsLocations")));
    }

    public void merge(Connection connectionData) {
        this.name = connectionData.name;
        this.metaData = connectionData.metaData;
        this.protocol = connectionData.protocol;
        this.environment = connectionData.environment;
        this.status = connectionData.status;
    }

    public boolean mergeMetaData(Map<String, Object> provider) {
        boolean changed = true;
        Integer newManageVersion = (Integer)provider.get("version");
        if (newManageVersion.equals(this.manageVersion)) {
            return false;
        }
        this.manageIdentifier = (String)provider.get("id");
        this.manageVersion = newManageVersion;
        this.metaData = new HashMap();
        Map data = (Map)provider.get("data");
        this.manageEid = (Integer)data.get("eid");
        String entityID = (String)data.get("entityid");
        this.metaData.put("entityID", entityID);
        this.metaData.put("allowedall", data.get("allowedall"));
        List allowedEntities = data.getOrDefault("allowedEntities", List.of());
        List<String> allowedEntitiesMapped = allowedEntities.stream().map(m -> (String)m.get("name")).toList();
        this.metaData.put("allowedEntities", allowedEntitiesMapped);
        this.metaData.put("arp", data.get("arp"));
        Map metaDataFields = (Map)data.get("metaDataFields");
        this.metaData.put("pkce", metaDataFields.get("isPublicClient"));
        this.metaData.put("grantTypes", metaDataFields.get("grants"));
        this.metaData.put("secret", metaDataFields.get("secret"));
        this.metaData.put("redirectUrls", metaDataFields.get("redirectUrls"));
        ArrayList acsLocations = new ArrayList();
        IntStream.of(0, 1, 2, 3, 4, 5).forEach(index -> {
            if (metaDataFields.containsKey("AssertionConsumerService:" + index + ":Location")) {
                acsLocations.add((String)metaDataFields.get("AssertionConsumerService:" + index + ":Location"));
            }
        });
        this.metaData.put("acsLocations", acsLocations);
        this.metaData.put("logoUrl", metaDataFields.get("logo:0:url"));
        ArrayList contactPersons = new ArrayList();
        IntStream.of(0, 1, 2, 3, 4, 5).forEach(index -> {
            if (metaDataFields.containsKey("contacts:" + index + ":emailAddress")) {
                Contact contact = new Contact((String)metaDataFields.get("contacts:" + index + ":contactType"), (String)metaDataFields.get("contacts:" + index + ":givenName"), (String)metaDataFields.get("contacts:" + index + ":surName"), (String)metaDataFields.get("contacts:" + index + ":emailAddress"));
                contactPersons.add(contact);
            }
        });
        this.metaData.put("contactPersons", contactPersons);
        boolean ssHidden = metaDataFields.getOrDefault("coin:ss:hidden", false);
        boolean idpVisibleOnly = metaDataFields.getOrDefault("coin:ss:idp_visible_only", false);
        String visibility = ssHidden ? Visibility.visible_to_none.name() : (idpVisibleOnly ? Visibility.visible_to_idp_only.name() : Visibility.visible_to_all.name());
        this.metaData.put("visibility", visibility);
        String connectOption = (String)metaDataFields.getOrDefault("coin:dashboard_connect_option", ConnectOptions.connect_with_interaction);
        this.metaData.put("connectOption", connectOption);
        this.state = State.valueOf((String)((String)data.get("state")));
        if (this.environment.equals((Object)Environment.PROD) && ConnectionStatus.PENDING_PROD.equals((Object)this.status) && this.state.equals((Object)State.prodaccepted)) {
            this.status = ConnectionStatus.PROD_READY;
        }
        return changed;
    }

    @JsonIgnore
    public void updateRemoteManageData(Map<String, Object> provider) {
        this.manageIdentifier = (String)provider.get("id");
        this.manageVersion = (Integer)provider.get("version");
        Map data = (Map)provider.get("data");
        this.manageEid = (Integer)data.get("eid");
        this.state = State.valueOf((String)((String)data.get("state")));
    }

    @Generated
    public Connection() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Application getApplication() {
        return this.application;
    }

    @Generated
    public Map<String, Object> getMetaData() {
        return this.metaData;
    }

    @Generated
    public EntityType getProtocol() {
        return this.protocol;
    }

    @Generated
    public Environment getEnvironment() {
        return this.environment;
    }

    @Generated
    public State getState() {
        return this.state;
    }

    @Generated
    public ConnectionStatus getStatus() {
        return this.status;
    }

    @Generated
    public String getManageIdentifier() {
        return this.manageIdentifier;
    }

    @Generated
    public Integer getManageVersion() {
        return this.manageVersion;
    }

    @Generated
    public Integer getManageEid() {
        return this.manageEid;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Generated
    public void setApplication(Application application) {
        this.application = application;
    }

    @Generated
    public void setMetaData(Map<String, Object> metaData) {
        this.metaData = metaData;
    }

    @Generated
    public void setProtocol(EntityType protocol) {
        this.protocol = protocol;
    }

    @Generated
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Generated
    public void setState(State state) {
        this.state = state;
    }

    @Generated
    public void setStatus(ConnectionStatus status) {
        this.status = status;
    }

    @Generated
    public void setManageIdentifier(String manageIdentifier) {
        this.manageIdentifier = manageIdentifier;
    }

    @Generated
    public void setManageVersion(Integer manageVersion) {
        this.manageVersion = manageVersion;
    }

    @Generated
    public void setManageEid(Integer manageEid) {
        this.manageEid = manageEid;
    }

    @Generated
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }
}

