/*
 * Decompiled with CFR 0.152.
 */
package access.jira;

import java.io.IOException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class APITokenHeaderInterceptor
implements ClientHttpRequestInterceptor {
    private final String apiTokenHeaderValue;

    public APITokenHeaderInterceptor(String apiToken) {
        this.apiTokenHeaderValue = "Bearer " + apiToken;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        HttpHeaders headers = request.getHeaders();
        headers.set("Authorization", this.apiTokenHeaderValue);
        return execution.execute(request, body);
    }
}

