/*
 * Decompiled with CFR 0.152.
 */
package access.security;

import access.exception.ExtendedErrorAttributes;
import access.manage.Manage;
import access.repository.UserRepository;
import access.security.AuthorizationRequestCustomizer;
import access.security.CustomOidcUserService;
import access.security.LocalDevelopmentAuthenticationFilter;
import jakarta.servlet.Filter;
import java.util.Locale;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.client.web.DefaultOAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.context.DelegatingSecurityContextRepository;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.RequestAttributeSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.i18n.AcceptHeaderLocaleResolver;

@EnableWebSecurity
@EnableScheduling
@Configuration
@EnableMethodSecurity
public class SecurityConfig {
    public static final String API_TOKEN_HEADER = "X-API-TOKEN";
    private final ClientRegistrationRepository clientRegistrationRepository;
    private final Environment environment;
    private final String eduidIdpEntityId;

    @Autowired
    public SecurityConfig(ClientRegistrationRepository clientRegistrationRepository, Environment environment, @Value(value="${eduid-idp-entity-id}") String eduidIdpEntityId) {
        this.clientRegistrationRepository = clientRegistrationRepository;
        this.environment = environment;
        this.eduidIdpEntityId = eduidIdpEntityId;
    }

    @Bean
    public CookieSerializer cookieSerializer(@Value(value="${server.servlet.session.cookie.secure}") boolean secure) {
        DefaultCookieSerializer serializer = new DefaultCookieSerializer();
        serializer.setUseSecureCookie(secure);
        return serializer;
    }

    @Bean
    @Order(value=1)
    SecurityFilterChain sessionSecurityFilterChain(HttpSecurity http, UserRepository userRepository, Manage manage, @Value(value="${institution-admin.entitlement}") String entitlement, @Value(value="${institution-admin.organization-guid-prefix}") String organizationGuidPrefix) throws Exception {
        http.csrf(csrfConfigurer -> csrfConfigurer.ignoringRequestMatchers(new String[]{"/api/v1/test/login", "/login/oauth2/code/oidcng", "/api/v1/validations/**"})).securityMatcher(new String[]{"/login/oauth2/**", "/oauth2/authorization/**", "/api/v1/**"}).authorizeHttpRequests(authorizeHttpRequestsConfigurer -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizeHttpRequestsConfigurer.requestMatchers(new String[]{"/api/v1/csrf", "/api/v1/disclaimer", "/api/v1/users/config", "/api/v1/users/logout", "/api/v1/validations/**", "/api/v1/test/login", "/api/v1/public/**", "/ui/**", "/internal/**"})).permitAll().anyRequest()).authenticated()).oauth2Login(oAuth2LoginConfigurer -> oAuth2LoginConfigurer.authorizationEndpoint(authorization -> authorization.authorizationRequestResolver(this.authorizationRequestResolver(this.clientRegistrationRepository))).userInfoEndpoint(userInfoEndpointConfigurer -> userInfoEndpointConfigurer.oidcUserService((OAuth2UserService)new CustomOidcUserService(userRepository, manage, entitlement, organizationGuidPrefix)))).securityContext(securityContextConfigurer -> securityContextConfigurer.securityContextRepository(this.securityContextRepository()));
        if (this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"local"}))) {
            http.addFilterBefore((Filter)new LocalDevelopmentAuthenticationFilter(), AnonymousAuthenticationFilter.class);
        }
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public SecurityContextRepository securityContextRepository() {
        return new DelegatingSecurityContextRepository(new SecurityContextRepository[]{new RequestAttributeSecurityContextRepository(), new HttpSessionSecurityContextRepository()});
    }

    private OAuth2AuthorizationRequestResolver authorizationRequestResolver(ClientRegistrationRepository clientRegistrationRepository) {
        DefaultOAuth2AuthorizationRequestResolver authorizationRequestResolver = new DefaultOAuth2AuthorizationRequestResolver(clientRegistrationRepository, "/oauth2/authorization");
        authorizationRequestResolver.setAuthorizationRequestCustomizer((Consumer)new AuthorizationRequestCustomizer(this.eduidIdpEntityId));
        return authorizationRequestResolver;
    }

    @Bean
    public LocaleResolver localeResolver() {
        AcceptHeaderLocaleResolver slr = new AcceptHeaderLocaleResolver();
        slr.setDefaultLocale(Locale.ENGLISH);
        return slr;
    }

    @Bean
    ErrorAttributes errorAttributes() {
        return new ExtendedErrorAttributes();
    }
}

