/*
 * Decompiled with CFR 0.152.
 */
package access.model;

import access.model.ApplicationMembership;
import access.model.ApplicationStatus;
import access.model.ApplicationTarget;
import access.model.ApplicationType;
import access.model.Connection;
import access.model.NameHolder;
import access.model.Organization;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.hypersistence.utils.hibernate.type.json.JsonType;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.Hibernate;
import org.hibernate.annotations.Type;

@Entity(name="applications")
public class Application
implements NameHolder {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column
    @NotNull
    private String name;
    @Column(name="logo_url")
    private String logoUrl;
    @Type(value=JsonType.class)
    @Column(name="meta_data", columnDefinition="jsonb")
    private Map<String, Object> metaData = new HashMap();
    @Enumerated(value=EnumType.STRING)
    @Column
    @NotNull
    private ApplicationStatus status = ApplicationStatus.OPEN;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="organization_id")
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private Organization organization;
    @OneToMany(mappedBy="application", orphanRemoval=true, fetch=FetchType.LAZY)
    private Set<Connection> connections = new HashSet();
    @OneToMany(mappedBy="application", orphanRemoval=true, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Set<ApplicationMembership> applicationMemberships = new HashSet();
    @Column(name="created_at")
    private Instant createdAt;
    @Column
    private String createdBy;
    @Column(name="signed_contract")
    private boolean signedContract;
    @Enumerated(value=EnumType.STRING)
    @Column
    @NotNull
    private ApplicationTarget target = ApplicationTarget.SURF;
    @Enumerated(value=EnumType.STRING)
    @Column
    @NotNull
    private ApplicationType type = ApplicationType.APP;

    public Application(String name, Organization organization, String createdBy, Map<String, Object> metaData) {
        this.name = name;
        this.organization = organization;
        this.metaData = metaData;
        this.createdAt = Instant.now();
        this.createdBy = createdBy;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY, value="organization")
    public Map<String, Serializable> getOrganizationInfo() {
        Organization organization = this.getOrganization();
        HashMap<String, Serializable> organizationInfo = new HashMap<String, Serializable>();
        if (organization != null && Hibernate.isInitialized((Object)organization)) {
            organizationInfo.put("id", organization.getId());
            organizationInfo.put("name", (Serializable)((Object)organization.getName()));
            organizationInfo.put("schacHomeOrganization", (Serializable)((Object)organization.getSchacHomeOrganization()));
        }
        return organizationInfo;
    }

    @JsonIgnore
    public void removeConnection(Connection connection) {
        Set newConnections = this.connections.stream().filter(conn -> !conn.getId().equals(connection.getId())).collect(Collectors.toSet());
        this.connections.clear();
        this.connections.addAll(newConnections);
    }

    public void merge(Application applicationData) {
        this.name = applicationData.name;
        this.metaData = applicationData.metaData;
        this.type = applicationData.type;
        this.target = applicationData.target;
        this.logoUrl = applicationData.logoUrl;
        this.signedContract = applicationData.signedContract;
        this.status = applicationData.status;
    }

    @Generated
    public Application() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getLogoUrl() {
        return this.logoUrl;
    }

    @Generated
    public Map<String, Object> getMetaData() {
        return this.metaData;
    }

    @Generated
    public ApplicationStatus getStatus() {
        return this.status;
    }

    @Generated
    public Organization getOrganization() {
        return this.organization;
    }

    @Generated
    public Set<Connection> getConnections() {
        return this.connections;
    }

    @Generated
    public Set<ApplicationMembership> getApplicationMemberships() {
        return this.applicationMemberships;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public boolean isSignedContract() {
        return this.signedContract;
    }

    @Generated
    public ApplicationTarget getTarget() {
        return this.target;
    }

    @Generated
    public ApplicationType getType() {
        return this.type;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    @Generated
    public void setMetaData(Map<String, Object> metaData) {
        this.metaData = metaData;
    }

    @Generated
    public void setStatus(ApplicationStatus status) {
        this.status = status;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Generated
    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    @Generated
    public void setConnections(Set<Connection> connections) {
        this.connections = connections;
    }

    @Generated
    public void setApplicationMemberships(Set<ApplicationMembership> applicationMemberships) {
        this.applicationMemberships = applicationMemberships;
    }

    @Generated
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @Generated
    public void setSignedContract(boolean signedContract) {
        this.signedContract = signedContract;
    }

    @Generated
    public void setTarget(ApplicationTarget target) {
        this.target = target;
    }

    @Generated
    public void setType(ApplicationType type) {
        this.type = type;
    }
}

