/*
 * Decompiled with CFR 0.152.
 */
package access.jira;

import access.jira.JiraConfig;
import access.jira.JiraIssue;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.nimbusds.jose.util.IOUtils;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@EnableConfigurationProperties(value={JiraConfig.class})
@Service
public class JiraClient {
    private static final Logger LOG = LoggerFactory.getLogger(JiraClient.class);
    private final JiraConfig config;
    private final RestTemplate restTemplate = new RestTemplate();
    private final Map<String, Map<String, Map<String, String>>> mappings;
    private final String issueType;
    private HttpHeaders defaultHeaders;

    public JiraClient(JiraConfig config, ObjectMapper objectMapper) {
        this.config = config;
        this.mappings = (Map)objectMapper.readValue(new ClassPathResource("jira/mappings.json").getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        this.issueType = this.resolveIssueType();
        if (config.isEnabled()) {
            SimpleClientHttpRequestFactory requestFactory = (SimpleClientHttpRequestFactory)this.restTemplate.getRequestFactory();
            requestFactory.setReadTimeout(config.getConnectionTimeout());
            requestFactory.setConnectTimeout(config.getConnectionTimeout());
            this.defaultHeaders = new HttpHeaders();
            this.defaultHeaders.setContentType(MediaType.APPLICATION_JSON);
            this.defaultHeaders.add("Authorization", "Bearer " + config.getApiKey());
        }
    }

    public String create(JiraIssue issue) {
        if (!this.config.isEnabled()) {
            return String.format("CXT-%s", ThreadLocalRandom.current().nextInt(1000, 10000));
        }
        HashMap<Object, Object> fields = new HashMap<Object, Object>();
        fields.put("project", Map.of("key", this.config.getProjectKey()));
        fields.put("customfield_" + this.spCustomField(), issue.getEntityID());
        fields.put("customfield_" + this.typeMetaDataCustomField(), Map.of("value", issue.getEntityType().name()));
        fields.put("customfield_" + this.emailToCustomField(), issue.getEmailTo());
        fields.put("issuetype", ImmutableMap.of((Object)"id", (Object)this.issueType));
        fields.put("summary", issue.getSummary());
        fields.put("description", issue.getDescription());
        fields.put("duedate", this.dueDate());
        Map jiraIssue = Map.of("fields", fields);
        String jiraJson = IOUtils.readInputStreamToString((InputStream)new ClassPathResource("/jira/jira.json").getInputStream());
        LOG.info("Sending JSON {} to JIRA", (Object)jiraJson);
        try {
            HttpEntity entity = new HttpEntity((Object)jiraJson, (MultiValueMap)this.defaultHeaders);
            Map result = (Map)this.restTemplate.postForObject(this.config.getBaseUrl() + "/issue", (Object)entity, Map.class, new Object[0]);
            return (String)result.get("key");
        }
        catch (HttpClientErrorException e) {
            LOG.error("Failed to create Jira issue: {} ({}) with response:{}, JSON Request: {}", new Object[]{e.getStatusCode(), e.getStatusText(), e.getResponseBodyAsString(), jiraIssue, e});
            throw e;
        }
    }

    private String resolveIssueType() {
        return ((Map)((Map)this.mappings.get(this.config.getEnvironment())).get("issueTypes")).entrySet().stream().filter(entry -> ((String)entry.getKey()).equals("change")).map(entry -> (String)entry.getValue()).findFirst().get();
    }

    private String spCustomField() {
        return this.customField("spEntityId");
    }

    private String typeMetaDataCustomField() {
        return this.customField("typeMetaData");
    }

    private String emailToCustomField() {
        return this.customField("emailTo");
    }

    private String customField(String name) {
        return (String)((Map)((Map)this.mappings.get(this.config.getEnvironment())).get("customFields")).get(name);
    }

    private String dueDate() {
        LocalDate localDate = new Date().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        return localDate.plusDays(3L).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    }
}

