/*
 * Decompiled with CFR 0.152.
 */
package access.model;

import access.model.Application;
import access.model.Authority;
import access.model.NameHolder;
import access.model.OrganizationMembership;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.NotNull;
import java.time.Instant;
import lombok.Generated;

@Entity(name="application_memberships")
public class ApplicationMembership
implements NameHolder {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="created_at")
    private Instant createdAt;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="application_id")
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private Application application;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="organization_membership_id")
    private OrganizationMembership organizationMembership;
    @Enumerated(value=EnumType.STRING)
    @Column
    @NotNull
    private Authority authority = Authority.MEMBER;

    public ApplicationMembership(Application application, OrganizationMembership organizationMembership, Authority authority) {
        this.application = application;
        this.authority = authority;
        this.organizationMembership = organizationMembership;
        this.createdAt = Instant.now();
    }

    @Transient
    @JsonIgnore
    public String getName() {
        return this.getClass().getName().concat(this.application.getName()).concat(this.authority.name());
    }

    @Generated
    public ApplicationMembership() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Application getApplication() {
        return this.application;
    }

    @Generated
    public OrganizationMembership getOrganizationMembership() {
        return this.organizationMembership;
    }

    @Generated
    public Authority getAuthority() {
        return this.authority;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Generated
    public void setApplication(Application application) {
        this.application = application;
    }

    @Generated
    public void setOrganizationMembership(OrganizationMembership organizationMembership) {
        this.organizationMembership = organizationMembership;
    }

    @Generated
    public void setAuthority(Authority authority) {
        this.authority = authority;
    }
}

