/*
 * Decompiled with CFR 0.152.
 */
package access.manage;

import access.model.Application;
import access.model.ConnectOptions;
import access.model.Connection;
import access.model.EntityType;
import access.model.Environment;
import access.model.State;
import access.model.Visibility;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.StringUtils;

public class ConnectionProviderConverter {
    private final List<Map<String, Object>> privacyInfo;
    private final State defaultTestState;
    private final State defaultProdState;

    public ConnectionProviderConverter(ObjectMapper objectMapper, State defaultTestState, State defaultProdState) {
        this.defaultTestState = defaultTestState;
        this.defaultProdState = defaultProdState;
        this.privacyInfo = (List)objectMapper.readValue(new ClassPathResource("/metadata/Privacy.json").getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Map<String, Object> convert(Connection connection, Map<String, Object> result) {
        Application application = connection.getApplication();
        Map connectionMetaData = connection.getMetaData();
        Map applicationMetaData = application.getMetaData();
        Map information = applicationMetaData.getOrDefault("information", Map.of());
        Map data = (Map)result.get("data");
        Map metaDataFields = (Map)data.get("metaDataFields");
        this.putIf(result, "id", (Object)connection.getManageIdentifier());
        this.putIf(result, "version", (Object)connection.getManageVersion());
        result.put("type", connection.getProtocol().name());
        this.putIf(result, "eid", (Object)connection.getManageEid());
        data.put("entityid", connectionMetaData.get("entityID"));
        data.put("state", (connection.getEnvironment().equals((Object)Environment.TEST) ? this.defaultTestState : this.defaultProdState).name());
        data.put("allowedall", false);
        data.put("revisionnote", "SURF Access update with remote API");
        this.mergeAttributeReleasePolicies(connectionMetaData, data);
        this.mergeAllowedEntities(data, connectionMetaData);
        metaDataFields.put("name:en", connection.getName());
        metaDataFields.put("name:nl", connection.getName());
        this.putIf(metaDataFields, "logo:0:url", (Object)application.getLogoUrl());
        this.putIf(metaDataFields, "coin:application_name", (Object)application.getName());
        this.putIf(metaDataFields, "description:en", information.get("descriptionEN"));
        this.putIf(metaDataFields, "description:nl", information.get("descriptionNL"));
        this.putIf(metaDataFields, "coin:application_url", information.get("webSite"));
        List tags = information.getOrDefault("tags", List.of());
        this.putIf(metaDataFields, "application_tags", tags);
        if (EntityType.oidc10_rp.equals((Object)connection.getProtocol())) {
            List grantTypes = (List)connectionMetaData.get("grantTypes");
            this.putIf(metaDataFields, "grants", (Object)grantTypes);
            this.putIf(metaDataFields, "redirectUrls", connectionMetaData.get("redirectUrls"));
            metaDataFields.put("isPublicClient", connectionMetaData.getOrDefault("pkce", false));
            metaDataFields.put("oidc:claims_in_id_token", connectionMetaData.getOrDefault("claimsInIdToken", false));
            metaDataFields.put("accessTokenValidity", 3600);
            if (grantTypes.contains("refresh_token")) {
                metaDataFields.put("refreshTokenValidity", connectionMetaData.getOrDefault("refreshTokenValidity", 3600));
            }
            this.putIf(metaDataFields, "secret", connectionMetaData.get("secret"));
        }
        if (EntityType.saml20_sp.equals((Object)connection.getProtocol())) {
            List acsLocations = connectionMetaData.getOrDefault("acsLocations", Collections.emptyList());
            IntStream.range(0, acsLocations.size()).forEach(i -> {
                metaDataFields.put("AssertionConsumerService:" + i + ":Location", acsLocations.get(i));
                metaDataFields.put("AssertionConsumerService:" + i + ":Binding", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            });
        }
        String visibility = (String)connectionMetaData.get("visibility");
        metaDataFields.put("coin:ss:idp_visible_only", Visibility.visible_to_idp_only.name().equals(visibility));
        metaDataFields.put("coin:ss:hidden", Visibility.visible_to_none.name().equals(visibility));
        String connectOption = connectionMetaData.getOrDefault("connectOption", ConnectOptions.connect_with_interaction.name());
        metaDataFields.put("coin:dashboard_connect_option", connectOption);
        List contactPersons = applicationMetaData.getOrDefault("contactPersons", Collections.emptyList());
        IntStream.range(0, contactPersons.size()).forEach(i -> {
            Map contactPerson = (Map)contactPersons.get(i);
            Map.of("type", "contactType", "email", "emailAddress", "givenName", "givenName", "surName", "surName").forEach((k, v) -> this.putIf(metaDataFields, "contacts:" + i + ":" + v, contactPerson.get(k)));
        });
        Map privacy = applicationMetaData.getOrDefault("privacy", Map.of());
        this.privacyInfo.forEach(item -> this.putIf(metaDataFields, (String)item.get("manage"), privacy.get(item.get("name"))));
        metaDataFields.put("OrganizationName:en", application.getOrganization().getName());
        return result;
    }

    private void mergeAllowedEntities(Map<String, Object> data, Map<String, Object> connectionMetaData) {
        List<String> existingAllowedEntities = ((List)data.getOrDefault("allowedEntities", new ArrayList())).stream().map(m -> (String)m.get("name")).toList();
        List newAllowedEntities = connectionMetaData.getOrDefault("allowedEntities", List.of());
        LinkedHashSet<String> uniqueAllowedEntities = new LinkedHashSet<String>(existingAllowedEntities);
        uniqueAllowedEntities.addAll(newAllowedEntities);
        data.put("allowedEntities", uniqueAllowedEntities.stream().map(entity -> Map.of("name", entity)).toList());
    }

    private void mergeAttributeReleasePolicies(Map<String, Object> connectionMetaData, Map<String, Object> data) {
        Map newArp = (Map)connectionMetaData.get("arp");
        Map arpFromManage = (Map)data.get("arp");
        Map existingArpAttributes = (Map)arpFromManage.get("attributes");
        Map newArpAttributes = (Map)newArp.get("attributes");
        existingArpAttributes.entrySet().stream().forEach(entry -> {
            if (newArpAttributes.containsKey(entry.getKey())) {
                Map arpEntry = (Map)((List)newArpAttributes.get(entry.getKey())).getFirst();
                Map existingArpEntry = (Map)((List)entry.getValue()).getFirst();
                existingArpEntry.put("motivation", (String)arpEntry.get("motivation"));
            }
            newArpAttributes.put((String)entry.getKey(), (List)entry.getValue());
        });
        this.putIf(data, "arp", (Object)newArp);
    }

    private void putIf(Map<String, Object> result, String key, Object value) {
        if (value instanceof String && StringUtils.hasText((String)((String)value)) || value != null) {
            result.put(key, value);
        }
    }
}

