/*
 * Decompiled with CFR 0.152.
 */
package access.model;

import access.model.Language;
import access.model.NameHolder;
import access.model.Organization;
import access.model.User;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

@Entity(name="join_requests")
public class JoinRequest
implements NameHolder {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Enumerated(value=EnumType.STRING)
    private Language language;
    @Column
    private String message;
    @Column(name="created_at")
    private Instant createdAt;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="user_id")
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private User user;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="organization_id")
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private Organization organization;
    @Transient
    private String transientName;

    public JoinRequest(User user, Organization organization, String message, Language language) {
        this.user = user;
        this.organization = organization;
        this.message = message;
        this.language = language;
        this.createdAt = Instant.now();
        this.transientName = this.getClass().getName().concat(organization.getName()).concat(user.getName());
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY, value="organization")
    public Map<String, Serializable> getOrganizationInfo() {
        Organization organization = this.getOrganization();
        HashMap<String, Serializable> organizationInfo = new HashMap<String, Serializable>();
        if (organization != null) {
            organizationInfo.put("id", organization.getId());
            organizationInfo.put("name", (Serializable)((Object)organization.getName()));
        }
        return organizationInfo;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY, value="user")
    public Map<String, Serializable> getUserInfo() {
        User user = this.getUser();
        HashMap<String, Serializable> userInfo = new HashMap<String, Serializable>();
        if (user != null) {
            userInfo.put("id", user.getId());
            userInfo.put("name", (Serializable)((Object)user.getName()));
            userInfo.put("email", (Serializable)((Object)user.getEmail()));
            userInfo.put("schacHomeOrganization", (Serializable)((Object)user.getSchacHomeOrganization()));
        }
        return userInfo;
    }

    @Transient
    @JsonIgnore
    public String getName() {
        return this.transientName;
    }

    @Generated
    public JoinRequest() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Language getLanguage() {
        return this.language;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public User getUser() {
        return this.user;
    }

    @Generated
    public Organization getOrganization() {
        return this.organization;
    }

    @Generated
    public String getTransientName() {
        return this.transientName;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setLanguage(Language language) {
        this.language = language;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUser(User user) {
        this.user = user;
    }

    @Generated
    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    @Generated
    public void setTransientName(String transientName) {
        this.transientName = transientName;
    }
}

