/*
 * Decompiled with CFR 0.152.
 */
package access.security;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;

/*
 * Exception performing whole class analysis ignored.
 */
public class LocalDevelopmentAuthenticationFilter
implements Filter {
    private static final String sub = "urn:collab:person:eduid.nl:mos";

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            LocalDevelopmentAuthenticationFilter.populateSecurityContext(Map.of());
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public static void populateSecurityContext(Map<String, String> body) {
        List<SimpleGrantedAuthority> authorities = List.of(new SimpleGrantedAuthority("OPENID"));
        Map<String, List<String>> defaultClaims = Map.of("eduperson_principal_name", "urn:collab:person:example.com:super", "email", "email", "family_name", "Doe", "given_name", "John", "name", "John Doe", "schac_home_organization", "example.com", "scope", "openid", "sub", body.getOrDefault("sub", "urn:collab:person:eduid.nl:mos"), "uids", List.of("super"));
        HashMap<String, List<String>> claims = new HashMap<String, List<String>>(defaultClaims);
        claims.putAll(body);
        OidcIdToken idToken = new OidcIdToken(UUID.randomUUID().toString(), Instant.now(), Instant.now().plus(1L, ChronoUnit.HOURS), claims);
        OidcUserInfo userInfo = new OidcUserInfo(claims);
        DefaultOidcUser oidcUser = new DefaultOidcUser(authorities, idToken, userInfo);
        OAuth2AuthenticationToken authenticationToken = new OAuth2AuthenticationToken((OAuth2User)oidcUser, authorities, "oidcng");
        SecurityContextHolder.getContext().setAuthentication((Authentication)authenticationToken);
    }
}

