/*
 * Decompiled with CFR 0.152.
 */
package access.manage;

import access.exception.NotFoundException;
import access.manage.ChangeRequest;
import access.manage.ConnectionProviderConverter;
import access.manage.Manage;
import access.model.Connection;
import access.model.EntityType;
import access.model.Environment;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public final class LocalManage
implements Manage {
    private static final Log LOG = LogFactory.getLog(LocalManage.class);
    private final Map<EntityType, List<Map<String, Object>>> allProviders;
    private final DefaultResourceLoader defaultResourceLoader = new DefaultResourceLoader();
    private final ConnectionProviderConverter converter;
    private final ObjectMapper objectMapper;

    public LocalManage(ConnectionProviderConverter converter, ObjectMapper objectMapper, String staticManageDirectory) {
        this.converter = converter;
        this.objectMapper = objectMapper;
        this.allProviders = Stream.of(EntityType.values()).collect(Collectors.toMap(entityType -> entityType, entityType -> this.initialize(entityType, staticManageDirectory)));
    }

    private List<Map<String, Object>> initialize(EntityType entityType, String staticManageDirectory) {
        String resourceName = String.format("%s/%s.json", staticManageDirectory, entityType.name());
        Resource resource = this.defaultResourceLoader.getResource(resourceName);
        List providers = (List)this.objectMapper.readValue(resource.getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        return providers.stream().map(provider -> this.sanitizeProvider(provider)).collect(Collectors.toCollection(ArrayList::new));
    }

    public List<Map<String, Object>> providers(Environment environment, EntityType ... entityTypes) {
        LOG.debug((Object)("providers for : " + String.valueOf(List.of(entityTypes))));
        return Stream.of(entityTypes).map(entityType -> ((List)this.allProviders.get(entityType)).stream().toList()).flatMap(Collection::stream).toList();
    }

    public Map<String, Object> providerById(Connection connection) {
        String manageIdentifier = connection.getManageIdentifier();
        EntityType protocol = connection.getProtocol();
        Environment environment = connection.getEnvironment();
        LOG.debug((Object)("providerById for : " + String.valueOf(protocol)));
        List providers = this.providers(environment, new EntityType[]{protocol});
        return providers.stream().filter(provider -> provider.get("id").equals(manageIdentifier)).findFirst().orElseThrow(() -> new NotFoundException("Provider not found"));
    }

    public Map<String, Object> providerById(EntityType entityType, String manageIdentifier, Environment environment) {
        LOG.debug((Object)("providerById for : " + String.valueOf(entityType)));
        List providers = this.providers(environment, new EntityType[]{entityType});
        return providers.stream().filter(provider -> provider.get("id").equals(manageIdentifier)).findFirst().orElseThrow(() -> new NotFoundException("Provider not found"));
    }

    public Map<String, Object> saveProvider(Connection connection) {
        Map baseStructure = StringUtils.hasText((String)connection.getManageIdentifier()) ? this.providerById(connection) : this.baseStructureProvider();
        Map provider = this.converter.convert(connection, baseStructure, false);
        boolean existingProvider = provider.containsKey("id");
        if (existingProvider) {
            provider.put("version", (Integer)provider.get("version") + 1);
        } else {
            provider.put("id", UUID.randomUUID().toString());
            provider.put("version", 0);
        }
        List providers = (List)this.allProviders.get(connection.getProtocol());
        if (existingProvider) {
            int index = IntStream.range(0, providers.size()).filter(i -> ((Map)providers.get(i)).get("id") == provider.get("id")).findFirst().orElse(-1);
            if (index != -1) {
                providers.set(index, provider);
            }
        } else {
            providers.add(provider);
        }
        return provider;
    }

    public void deleteProvider(Connection connection) {
        List<Map> newProviders = ((List)this.allProviders.get(connection.getProtocol())).stream().filter(provider -> !provider.get("id").equals(connection.getManageIdentifier())).toList();
        this.allProviders.put(connection.getProtocol(), newProviders);
    }

    public List<Map<String, Object>> providersByEntityID(Environment environment, EntityType entityType, String entityID) {
        return Stream.of(EntityType.values()).flatMap(type -> ((List)this.allProviders.get(type)).stream()).filter(provider -> ((Map)provider.get("data")).get("entityid").equals(entityID)).toList();
    }

    public Map<String, Object> createChangeRequest(Environment environment, ChangeRequest changeRequest) {
        return Map.of();
    }

    public void rejectChangeRequest(Environment environment, ChangeRequest changeRequest) {
    }

    public List<Map<String, Object>> getChangeRequests(Environment environment, Connection connection) {
        return List.of();
    }

    public String changeRequestURL(Environment environment, Connection connection) {
        return String.format("http://localhost:8088/metadata/%s/%s", connection.getProtocol().name(), connection.getManageIdentifier());
    }

    public Optional<Map<String, Object>> identityProviderByInstitutionalGUID(Environment environment, String organisationGUID) {
        return ((List)this.allProviders.get(EntityType.saml20_idp)).stream().filter(provider -> {
            Map data = (Map)provider.get("data");
            Map metaDataFields = (Map)data.get("metaDataFields");
            return organisationGUID.equalsIgnoreCase((String)metaDataFields.get("coin:institution_guid"));
        }).findFirst();
    }

    public List<Map<String, Object>> identityProvidersLight(Environment environment) {
        return (List)this.allProviders.get(EntityType.saml20_idp);
    }

    public List<Map<String, Object>> serviceProvidersLight(Environment environment) {
        ArrayList<Map<String, Object>> providers = new ArrayList<Map<String, Object>>();
        providers.addAll((Collection)this.allProviders.get(EntityType.saml20_sp));
        providers.addAll((Collection)this.allProviders.get(EntityType.oidc10_rp));
        return providers;
    }

    public Map<String, Integer> stats() {
        return Arrays.stream(EntityType.values()).collect(Collectors.toMap(entityType -> entityType.name(), entityType -> ((List)this.allProviders.get(entityType)).size()));
    }
}

