/*
 * Decompiled with CFR 0.152.
 */
package access.manage;

import access.exception.NotFoundException;
import access.manage.ChangeRequest;
import access.manage.ConnectionProviderConverter;
import access.manage.JSONHeaderInterceptor;
import access.manage.Manage;
import access.manage.ManageAuthorization;
import access.manage.ResilientErrorHandler;
import access.model.Connection;
import access.model.EntityType;
import access.model.Environment;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class RemoteManage
implements Manage {
    private static final Log LOG = LogFactory.getLog(RemoteManage.class);
    private final Map<Environment, RestTemplate> restTemplates = Map.of(Environment.TEST, new RestTemplate((ClientHttpRequestFactory)new BufferingClientHttpRequestFactory((ClientHttpRequestFactory)new SimpleClientHttpRequestFactory())), Environment.PROD, new RestTemplate((ClientHttpRequestFactory)new BufferingClientHttpRequestFactory((ClientHttpRequestFactory)new SimpleClientHttpRequestFactory())));
    private final Map<String, Object> queries;
    private final ConnectionProviderConverter converter;
    private final ManageAuthorization testAuthorization;
    private final ManageAuthorization productionAuthorization;
    private final Environment activeEnvironment;

    public RemoteManage(ManageAuthorization testAuthorization, ManageAuthorization productionAuthorization, ConnectionProviderConverter converter, Environment activeEnvironment, ObjectMapper objectMapper) throws IOException {
        this.testAuthorization = testAuthorization;
        this.productionAuthorization = productionAuthorization;
        this.converter = converter;
        this.activeEnvironment = activeEnvironment;
        this.queries = (Map)objectMapper.readValue(new ClassPathResource("/manage/query_templates.json").getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        ResilientErrorHandler resilientErrorHandler = new ResilientErrorHandler(objectMapper);
        this.restTemplates.forEach((arg_0, arg_1) -> RemoteManage.lambda$new$0(testAuthorization, productionAuthorization, (ResponseErrorHandler)resilientErrorHandler, arg_0, arg_1));
    }

    public List<Map<String, Object>> providers(Environment environment, EntityType ... entityTypes) {
        LOG.debug((Object)("Providers for entityTypes: " + String.valueOf(List.of(entityTypes))));
        return Stream.of(entityTypes).map(entityType -> this.getRemoteMetaData(environment, entityType.name(), false)).flatMap(Collection::stream).toList();
    }

    public Map<String, Object> providerById(Connection connection) {
        String manageIdentifier = connection.getManageIdentifier();
        EntityType protocol = connection.getProtocol();
        Environment environment = connection.getEnvironment();
        LOG.debug((Object)("providerById: " + String.valueOf(protocol)));
        return this.providerDetails(environment, protocol, manageIdentifier);
    }

    private Map providerDetails(Environment environment, EntityType protocol, String manageIdentifier) {
        String url = this.environmentUrl(environment);
        String queryUrl = String.format("%s/manage/api/internal/metadata/%s/%s", url, protocol.name(), manageIdentifier);
        RestTemplate restTemplate = this.environmentRestTemplate(environment);
        return (Map)restTemplate.getForEntity(queryUrl, Map.class, new Object[0]).getBody();
    }

    public Map<String, Object> providerById(EntityType entityType, String manageIdentifier, Environment environment) {
        LOG.debug((Object)("providerById: " + String.valueOf(entityType)));
        return this.providerDetails(environment, entityType, manageIdentifier);
    }

    public Map<String, Object> saveProvider(Connection connection) {
        Map baseStructure = StringUtils.hasText((String)connection.getManageIdentifier()) ? this.providerById(connection) : this.baseStructureProvider();
        Map provider = this.converter.convert(connection, baseStructure, connection.changeRequestRequired());
        RestTemplate restTemplate = this.environmentRestTemplate(connection.getEnvironment());
        String url = this.environmentUrl(connection.getEnvironment());
        HttpMethod httpMethod = StringUtils.hasText((String)connection.getManageIdentifier()) ? HttpMethod.PUT : HttpMethod.POST;
        ResponseEntity responseEntity = restTemplate.exchange(String.format("%s/manage/api/internal/metadata", url), httpMethod, new HttpEntity((Object)provider), Map.class, new Object[0]);
        Map body = (Map)responseEntity.getBody();
        if (ResilientErrorHandler.ignoreError((Map)body)) {
            return provider;
        }
        return body;
    }

    public void deleteProvider(Connection connection) {
        Environment environment = connection.getEnvironment();
        RestTemplate restTemplate = this.environmentRestTemplate(environment);
        String url = String.format("%s/manage/api/internal/metadata/%s/%s", this.environmentUrl(environment), connection.getProtocol(), connection.getManageIdentifier());
        restTemplate.exchange(URI.create(url), HttpMethod.DELETE, null, Void.class);
    }

    public void rejectChangeRequest(Environment environment, ChangeRequest changeRequest) {
        RestTemplate restTemplate = this.environmentRestTemplate(environment);
        String url = String.format("%s/manage/api/internal/change-requests/reject", this.environmentUrl(environment));
        restTemplate.put(URI.create(url), (Object)changeRequest);
    }

    public List<Map<String, Object>> uniqueEntityId(Environment environment, EntityType entityType, String entityID) {
        RestTemplate restTemplate = this.environmentRestTemplate(environment);
        String url = this.environmentUrl(environment);
        String queryUrl = String.format("%s/manage/api/internal/uniqueEntityId/%s", url, entityType.name());
        return (List)restTemplate.postForEntity(queryUrl, Map.of("entityid", entityID), List.class, new Object[0]).getBody();
    }

    public Map<String, Object> createChangeRequest(Environment environment, ChangeRequest changeRequest) {
        RestTemplate restTemplate = this.environmentRestTemplate(environment);
        String url = String.format("%s/manage/api/internal/change-requests", this.environmentUrl(environment));
        HttpEntity requestEntity = new HttpEntity((Object)changeRequest);
        ResponseEntity responseEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        return (Map)responseEntity.getBody();
    }

    public List<Map<String, Object>> getChangeRequests(Environment environment, Connection connection) {
        RestTemplate restTemplate = this.environmentRestTemplate(environment);
        String url = String.format("%s/manage/api/internal/change-requests/%s/%s", this.environmentUrl(environment), connection.getProtocol().name(), connection.getManageIdentifier());
        return (List)restTemplate.getForEntity(url, List.class, new Object[0]).getBody();
    }

    public String changeRequestURL(Environment environment, Connection connection) {
        String url = this.environmentUrl(environment);
        return String.format("%s/metadata/%s/%s/requests", url, connection.getProtocol().name(), connection.getManageIdentifier());
    }

    public Map<String, Object> identityProviderByEntityID(String entityID) {
        LOG.debug((Object)("identityProvidersByEntityID for : " + entityID));
        Map baseQuery = this.getBaseQuery(true);
        baseQuery.put("entityid", entityID);
        String url = String.format("%s/manage/api/internal/search/%s", this.environmentUrl(this.activeEnvironment), EntityType.saml20_idp.name());
        List identityProviders = (List)this.environmentRestTemplate(this.activeEnvironment).postForObject(url, (Object)baseQuery, List.class, new Object[0]);
        if (identityProviders.isEmpty()) {
            throw new NotFoundException("No identityProviders found for entityID: " + entityID);
        }
        return (Map)identityProviders.getFirst();
    }

    public List<Map<String, Object>> serviceProvidersByEntityID(List<String> entityIdentifiers) {
        LOG.debug((Object)("serviceProvidersByEntityID for : " + String.valueOf(entityIdentifiers)));
        Map baseQuery = this.getBaseQuery(true);
        baseQuery.put("entityid", entityIdentifiers);
        return Stream.of(EntityType.oidc10_rp, EntityType.saml20_sp).flatMap(entityType -> {
            String url = String.format("%s/manage/api/internal/search/%s", this.environmentUrl(this.activeEnvironment), entityType.name());
            List identityProviders = (List)this.environmentRestTemplate(this.activeEnvironment).postForObject(url, (Object)baseQuery, List.class, new Object[0]);
            return identityProviders.stream();
        }).toList();
    }

    public Optional<Map<String, Object>> identityProviderByInstitutionalGUID(Environment environment, String organisationGUID) {
        LOG.debug((Object)("identityProviderByInstitutionalGUID for : " + organisationGUID));
        Map baseQuery = this.getBaseQuery(false);
        baseQuery.put("metaDataFields.coin:institution_guid", organisationGUID);
        String url = String.format("%s/manage/api/internal/search/%s", this.environmentUrl(environment), EntityType.saml20_idp.name());
        List identityProviders = (List)this.environmentRestTemplate(environment).postForObject(url, (Object)baseQuery, List.class, new Object[0]);
        return identityProviders.isEmpty() ? Optional.empty() : Optional.of((Map)identityProviders.get(0));
    }

    public List<Map<String, Object>> identityProvidersLight(Environment environment) {
        LOG.debug((Object)("identityProvidersLight for environment: " + String.valueOf(environment)));
        Map baseQuery = this.getBaseQuery(false);
        ((List)baseQuery.get("REQUESTED_ATTRIBUTES")).add("metaDataFields.coin:institution_type");
        String url = String.format("%s/manage/api/internal/search/%s", this.environmentUrl(environment), EntityType.saml20_idp.name());
        return (List)this.environmentRestTemplate(environment).postForObject(url, (Object)baseQuery, List.class, new Object[0]);
    }

    public List<Map<String, Object>> serviceProvidersLight(Environment environment) {
        LOG.debug((Object)("serviceProvidersLight for environment: " + String.valueOf(environment)));
        Map baseQuery = this.getBaseQuery(false);
        List requestedAttributes = (List)baseQuery.get("REQUESTED_ATTRIBUTES");
        requestedAttributes.add("metaDataFields.coin:interfed_source");
        requestedAttributes.add("metaDataFields.application_tags");
        String url = String.format("%s/manage/api/internal/search/%s", this.environmentUrl(environment), EntityType.saml20_sp.name());
        List serviceProviders = (List)this.environmentRestTemplate(environment).postForObject(url, (Object)baseQuery, List.class, new Object[0]);
        url = String.format("%s/manage/api/internal/search/%s", this.environmentUrl(environment), EntityType.oidc10_rp.name());
        List relyingParties = (List)this.environmentRestTemplate(environment).postForObject(url, (Object)baseQuery, List.class, new Object[0]);
        serviceProviders.addAll(relyingParties);
        return serviceProviders;
    }

    public Map<String, Integer> stats() {
        LOG.debug((Object)"stats");
        String url = String.format("%s/manage/api/internal/stats", this.environmentUrl(Environment.PROD), EntityType.saml20_idp.name());
        return (Map)this.environmentRestTemplate(Environment.PROD).getForEntity(url, Map.class, new Object[0]).getBody();
    }

    private List<Map<String, Object>> getRemoteMetaData(Environment environment, String type, boolean allAttributes) {
        Map baseQuery = this.getBaseQuery(allAttributes);
        String url = String.format("%s/manage/api/internal/search/%s", this.environmentUrl(environment), type);
        return (List)this.environmentRestTemplate(environment).postForObject(url, (Object)baseQuery, List.class, new Object[0]);
    }

    private Map<String, Object> getBaseQuery(boolean allAttributes) {
        HashMap<String, Object> baseQuery = new HashMap<String, Object>((Map)this.queries.get("base_query"));
        if (!allAttributes) {
            baseQuery.put("REQUESTED_ATTRIBUTES", baseQuery.get("REQUESTED_ATTRIBUTES"));
        } else {
            baseQuery.remove("REQUESTED_ATTRIBUTES");
            baseQuery.put("ALL_ATTRIBUTES", true);
        }
        return baseQuery;
    }

    private String environmentUrl(Environment environment) {
        return environment.equals((Object)Environment.TEST) ? this.testAuthorization.url() : this.productionAuthorization.url();
    }

    private RestTemplate environmentRestTemplate(Environment environment) {
        return (RestTemplate)this.restTemplates.get(environment);
    }

    private static /* synthetic */ void lambda$new$0(ManageAuthorization testAuthorization, ManageAuthorization productionAuthorization, ResponseErrorHandler resilientErrorHandler, Environment environment, RestTemplate restTemplate) {
        List interceptors = restTemplate.getInterceptors();
        ManageAuthorization authorization = environment.equals((Object)Environment.TEST) ? testAuthorization : productionAuthorization;
        interceptors.add(new BasicAuthenticationInterceptor(authorization.user(), authorization.password()));
        interceptors.add(new JSONHeaderInterceptor());
        restTemplate.setErrorHandler(resilientErrorHandler);
    }
}

