/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.api.FullSearchQueryParser;
import access.api.Results;
import access.api.UserAccessRights;
import access.config.Config;
import access.exception.InvalidInputException;
import access.exception.NotFoundException;
import access.jira.JiraClient;
import access.jira.JiraIssue;
import access.manage.Manage;
import access.model.Authority;
import access.model.Connection;
import access.model.EntityType;
import access.model.Environment;
import access.model.Organization;
import access.model.OrganizationForm;
import access.model.OrganizationMembership;
import access.model.OrganizationStatus;
import access.model.User;
import access.repository.OrganizationMembershipRepository;
import access.repository.OrganizationRepository;
import access.repository.UserRepository;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/organizations"}, produces={"application/json"})
@Transactional
@EnableConfigurationProperties(value={Config.class})
@SecurityRequirements(value={@SecurityRequirement(name="openId", scopes={"openid"}), @SecurityRequirement(name="apiTokens")})
public class OrganizationController
implements UserAccessRights {
    private static final Log LOG = LogFactory.getLog(OrganizationController.class);
    private final OrganizationRepository organizationRepository;
    private final OrganizationMembershipRepository organizationMembershipRepository;
    private final Config config;
    private final Manage manage;
    private final UserRepository userRepository;
    private final JiraClient jiraClient;

    @Autowired
    public OrganizationController(OrganizationRepository organizationRepository, OrganizationMembershipRepository organizationMembershipRepository, Manage manage, UserRepository userRepository, Config config, JiraClient jiraClient) {
        this.organizationRepository = organizationRepository;
        this.organizationMembershipRepository = organizationMembershipRepository;
        this.manage = manage;
        this.config = config;
        this.userRepository = userRepository;
        this.jiraClient = jiraClient;
    }

    @GetMapping(value={"/find/{id}"})
    public ResponseEntity<Organization> find(User user, @PathVariable(value="id") Long id, @RequestParam(value="withIdp", required=false, defaultValue="false") boolean withIdp) {
        LOG.debug((Object)("/find Organization by " + user.getEmail()));
        Organization organization = (Organization)this.organizationRepository.findDetailsById(id).orElseThrow(() -> new NotFoundException("Organisation not found"));
        User userFromDB = this.reinitializeUser(user, this.userRepository);
        this.confirmOrganizationMembership(userFromDB, organization, Authority.MEMBER);
        if (StringUtils.hasText((String)organization.getManageIdentifier()) && withIdp) {
            Map provider = this.manage.providerById(EntityType.saml20_idp, organization.getManageIdentifier(), Environment.PROD);
            if (organization.mergeMetaData(provider, false)) {
                this.organizationRepository.save((Object)organization);
            }
            List changeRequests = this.manage.getChangeRequestsIdentityProvider(provider);
            organization.convertChangeRequests(changeRequests);
        }
        organization.getApplications().forEach(application -> {
            List<Connection> prodConnections = application.getConnections().stream().filter(conn -> conn.getEnvironment().equals((Object)Environment.PROD)).toList();
            if (prodConnections.size() == 1) {
                prodConnections.forEach(connection -> connection.convertChangeRequests(this.manage.getChangeRequests(Environment.PROD, connection)));
            }
        });
        return ResponseEntity.ok((Object)organization);
    }

    @GetMapping(value={"/search"})
    public ResponseEntity<Page<Map<String, Object>>> search(@Parameter(hidden=true) User user, @RequestParam(value="query", required=false, defaultValue="") String query, @RequestParam(value="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(value="pageSize", required=false, defaultValue="10") int pageSize, @RequestParam(value="sort", required=false, defaultValue="name") String sort, @RequestParam(value="sortDirection", required=false, defaultValue="ASC") String sortDirection) {
        LOG.debug((Object)String.format("/search/paginated for user %s", user.getEduPersonPrincipalName()));
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort)Sort.by((Sort.Direction)Sort.Direction.fromString((String)sortDirection), (String[])new String[]{sort}));
        Page usersPage = StringUtils.hasText((String)query) ? this.organizationRepository.searchByPageWithKeyword(FullSearchQueryParser.parse((String)query), (Pageable)pageable) : this.organizationRepository.searchByPage((Pageable)pageable);
        return ResponseEntity.ok((Object)usersPage);
    }

    @GetMapping(value={"/users/{id}"})
    public ResponseEntity<Organization> light(User user, @PathVariable(value="id") Long id) {
        LOG.debug((Object)("/find Organization light by " + user.getEmail()));
        Organization organization = (Organization)this.organizationRepository.findUsersById(id).orElseThrow(() -> new NotFoundException("Organisation not found"));
        User userFromDB = this.reinitializeUser(user, this.userRepository);
        this.confirmOrganizationMembership(userFromDB, organization, Authority.GUEST);
        return ResponseEntity.ok((Object)organization);
    }

    @GetMapping(value={"/light/{id}"})
    public ResponseEntity<Organization> light(@PathVariable(value="id") Long id) {
        LOG.debug((Object)"/light");
        Organization organization = (Organization)this.organizationRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Organisation not found"));
        return ResponseEntity.ok((Object)organization);
    }

    @GetMapping(value={"/invitation/{id}"})
    public ResponseEntity<Organization> name(@PathVariable(value="id") Long id) {
        LOG.debug((Object)"/name");
        Organization organization = (Organization)this.organizationRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Organisation not found"));
        Hibernate.initialize((Object)organization.getApplications());
        return ResponseEntity.ok((Object)organization);
    }

    @GetMapping(value={"/status/pending"})
    public ResponseEntity<List<Organization>> pendingApproval(User user) {
        LOG.debug((Object)("/pendingApproval Organizations by " + user.getEmail()));
        this.confirmSuperUser(user);
        List organizations = this.organizationRepository.findByStatus(OrganizationStatus.PENDING_APPROVAL);
        return ResponseEntity.ok((Object)organizations);
    }

    @PostMapping(value={"", "/"})
    public ResponseEntity<Organization> create(User user, @RequestBody @Validated Organization organization) {
        String name = organization.getName();
        Organization newOrganization = this.createOrganization(user, name);
        String orgName = newOrganization.getName();
        LOG.info((Object)String.format("Creating new Organisation %s for %s", name, user.getEmail()));
        String summary = String.format("User %s created a new Organisation %s in Access.", user.getName(), orgName);
        String jiraKey = this.jiraClient.create(new JiraIssue(orgName, String.format("%s The new organisation is pending approval. Visit to evaluate:%s%s", summary, System.lineSeparator(), String.format("%s/system/organizationPendingApproval", this.config.getClientUrl())), summary, EntityType.oidc10_rp, user.getEmail()));
        LOG.info((Object)("Created Jira issue for new Organization: " + jiraKey));
        newOrganization.setTicketKey(jiraKey);
        Organization savedOrganization = (Organization)this.organizationRepository.save((Object)newOrganization);
        OrganizationMembership organizationMembership = new OrganizationMembership(user, savedOrganization, Authority.ADMIN);
        this.organizationMembershipRepository.save((Object)organizationMembership);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)savedOrganization);
    }

    @PutMapping(value={"", "/"})
    public ResponseEntity<Organization> update(User user, @RequestBody @Validated OrganizationForm organizationForm) {
        Organization organization = (Organization)this.organizationRepository.findById((Object)organizationForm.getId()).orElseThrow(() -> new NotFoundException("Organization not found"));
        if (StringUtils.hasText((String)organization.getManageIdentifier())) {
            throw new InvalidInputException("Can not update name, Organization has manage identifier. " + organization.getName());
        }
        User userFromDB = this.reinitializeUser(user, this.userRepository);
        this.confirmOrganizationMembership(userFromDB, organization, Authority.ADMIN);
        organization.setName(organizationForm.getName());
        Organization savedOrganization = (Organization)this.organizationRepository.save((Object)organization);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)savedOrganization);
    }

    @PutMapping(value={"/status/{organizationId}/{status}"})
    public ResponseEntity<Organization> approve(User user, @PathVariable(value="organizationId") Long organizationId, @PathVariable(value="status") OrganizationStatus status) {
        this.confirmSuperUser(user);
        Organization organization = (Organization)this.organizationRepository.findById((Object)organizationId).orElseThrow(() -> new NotFoundException("Organization not found"));
        organization.setStatus(status);
        Organization savedOrganization = (Organization)this.organizationRepository.save((Object)organization);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)savedOrganization);
    }

    @PutMapping(value={"/metadata/{organizationId}"})
    public ResponseEntity<Organization> updateMetaData(User user, @PathVariable(value="organizationId") Long organizationId, @RequestBody Map<String, Object> metaData) {
        Organization organization = (Organization)this.organizationRepository.findById((Object)organizationId).orElseThrow(() -> new NotFoundException("Organization not found"));
        if (!StringUtils.hasText((String)organization.getManageIdentifier())) {
            throw new InvalidInputException("Can not update metadata. Organization has no manage identifier: " + organization.getName());
        }
        User userFromDB = this.reinitializeUser(user, this.userRepository);
        this.confirmOrganizationMembership(userFromDB, organization, Authority.ADMIN);
        organization.setMetaData(metaData);
        this.manage.saveIdentityProvider(organization);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)organization);
    }

    @DeleteMapping(value={"", "/{organizationId}"})
    public ResponseEntity<Map<String, Integer>> delete(User user, @PathVariable(value="organizationId") Long organizationId) {
        LOG.debug((Object)("/delete organization by " + user.getEmail()));
        Organization organization = (Organization)this.organizationRepository.findById((Object)organizationId).orElseThrow(() -> new NotFoundException("Organization not found"));
        user = this.reinitializeUser(user, this.userRepository);
        this.confirmOrganizationMembership(user, organization, Authority.ADMIN);
        this.organizationRepository.deleteOrganizationById(organizationId);
        return Results.deleteResult();
    }

    private Organization createOrganization(User user, String name) {
        String orgSchacHomeOrganization = this.getOrgSchacHomeOrganization(user, name);
        return new Organization(name, orgSchacHomeOrganization);
    }

    private String getOrgSchacHomeOrganization(User user, String name) {
        String orgSchacHomeOrganization;
        String schacHomeOrganization = user.getSchacHomeOrganization().toLowerCase();
        if (this.config.getEduIdSchacHomeOrganization().equals(schacHomeOrganization)) {
            String normalizedName = name.replaceAll("[^a-zA-Z_ ]", "").trim().replaceAll(" ", "_").toLowerCase();
            orgSchacHomeOrganization = String.format("%s.%s", normalizedName, this.config.getEduIdSchacHomeOrganization());
        } else {
            orgSchacHomeOrganization = schacHomeOrganization;
        }
        return orgSchacHomeOrganization;
    }
}

