/*
 * Decompiled with CFR 0.152.
 */
package access.manage;

import access.manage.ChangeRequest;
import access.manage.ManageData;
import access.manage.RequestType;
import access.model.Application;
import access.model.ConnectOptions;
import access.model.Connection;
import access.model.EntityType;
import access.model.Environment;
import access.model.State;
import access.model.Visibility;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.StringUtils;

public class ConnectionProviderConverter {
    private final List<Map<String, Object>> privacyInfo;
    private final List<String> excludedARPAttributes;
    private final List<String> excludedAttributes = List.of("revisionNote");
    private final List<String> excludedMergeAttributesPaths = List.of("arp.attributes");
    private final State defaultTestState;
    private final State defaultProdState;
    private final ObjectMapper objectMapper;

    public ConnectionProviderConverter(ObjectMapper objectMapper, State defaultTestState, State defaultProdState) {
        this.defaultTestState = defaultTestState;
        this.defaultProdState = defaultProdState;
        this.objectMapper = objectMapper;
        this.privacyInfo = (List)objectMapper.readValue(new ClassPathResource("/metadata/Privacy.json").getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        Map arpInfo = (Map)objectMapper.readValue(new ClassPathResource("/metadata/ARP.json").getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        Set profileAttributes = ((List)arpInfo.get("profiles")).stream().map(m -> {
            List attributes = (List)m.get("attributes");
            List optionalAttributes = (List)m.get("optionalAttributes");
            attributes.addAll(optionalAttributes);
            return attributes;
        }).flatMap(Collection::stream).collect(Collectors.toSet());
        this.excludedARPAttributes = ((List)arpInfo.get("attributes")).stream().filter(m -> !profileAttributes.contains((String)m.get("name"))).map(m -> (String)m.get("urn")).toList();
    }

    public Map<String, Object> convert(Connection connection, Map<String, Object> remoteProvider, boolean changeRequestRequired) {
        Application application = connection.getApplication();
        Map connectionMetaData = connection.getMetaData();
        Map applicationMetaData = application.getMetaData();
        Map information = applicationMetaData.getOrDefault("information", Map.of());
        Map data = ManageData.getData(remoteProvider);
        Map metaDataFields = ManageData.getMetaDataFields((Map)data);
        this.putIf(remoteProvider, "id", (Object)connection.getManageIdentifier());
        remoteProvider.put("type", connection.getProtocol().name());
        this.putIf(remoteProvider, "eid", (Object)connection.getManageEid());
        data.put("entityid", connectionMetaData.get("entityID"));
        if (!StringUtils.hasText((String)((String)data.get("state")))) {
            data.put("state", (connection.getEnvironment().equals((Object)Environment.TEST) ? this.defaultTestState : this.defaultProdState).name());
        }
        metaDataFields.put("name:en", connection.getName());
        metaDataFields.put("name:nl", connection.getName());
        this.putIf(metaDataFields, "logo:0:url", (Object)application.getLogoUrl());
        this.putIf(metaDataFields, "coin:application_name", (Object)application.getName());
        this.putIf(metaDataFields, "description:en", information.get("descriptionEN"));
        this.putIf(metaDataFields, "description:nl", information.get("descriptionNL"));
        this.putIf(metaDataFields, "coin:application_url", information.get("webSite"));
        List tags = information.getOrDefault("tags", List.of());
        this.putIf(metaDataFields, "application_tags", tags);
        this.convertContactPersons(applicationMetaData, metaDataFields);
        Map privacy = applicationMetaData.getOrDefault("privacy", Map.of());
        this.privacyInfo.forEach(item -> this.putIf(metaDataFields, (String)item.get("manage"), privacy.get(item.get("name"))));
        metaDataFields.put("OrganizationName:en", application.getOrganization().getName());
        data.put("allowedall", false);
        data.put("revisionnote", "SURF Access update with remote API");
        if (changeRequestRequired) {
            return remoteProvider;
        }
        this.mergeAttributeReleasePolicies(connectionMetaData, data);
        if (connection.getEnvironment().equals((Object)Environment.TEST)) {
            this.mergeAllowedEntities(data, connectionMetaData);
        }
        if (EntityType.oidc10_rp.equals((Object)connection.getProtocol())) {
            List grantTypes = (List)connectionMetaData.get("grantTypes");
            this.putIf(metaDataFields, "grants", (Object)grantTypes);
            this.putIf(metaDataFields, "redirectUrls", connectionMetaData.get("redirectUrls"));
            metaDataFields.put("isPublicClient", connectionMetaData.getOrDefault("pkce", false));
            metaDataFields.put("oidc:claims_in_id_token", connectionMetaData.getOrDefault("claimsInIdToken", false));
            metaDataFields.put("accessTokenValidity", 3600);
            if (grantTypes.contains("refresh_token")) {
                metaDataFields.put("refreshTokenValidity", connectionMetaData.getOrDefault("refreshTokenValidity", 3600));
            }
            this.putIf(metaDataFields, "secret", connectionMetaData.get("secret"));
        }
        if (EntityType.saml20_sp.equals((Object)connection.getProtocol())) {
            List acsLocations = connectionMetaData.getOrDefault("acsLocations", Collections.emptyList());
            IntStream.range(0, acsLocations.size()).forEach(i -> {
                metaDataFields.put("AssertionConsumerService:" + i + ":Location", acsLocations.get(i));
                metaDataFields.put("AssertionConsumerService:" + i + ":Binding", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            });
        }
        String visibility = (String)connectionMetaData.get("visibility");
        metaDataFields.put("coin:ss:idp_visible_only", Visibility.visible_to_idp_only.name().equals(visibility));
        metaDataFields.put("coin:ss:hidden", Visibility.visible_to_none.name().equals(visibility));
        String connectOption = connectionMetaData.getOrDefault("connectOption", ConnectOptions.connect_with_interaction.name());
        metaDataFields.put("coin:dashboard_connect_option", connectOption);
        return remoteProvider;
    }

    public void convertContactPersons(Map<String, Object> applicationMetaData, Map<String, Object> metaDataFields) {
        List<Map> contactPersons = applicationMetaData.getOrDefault("contactPersons", Collections.emptyList()).stream().filter(m -> StringUtils.hasText((String)((String)m.get("email")))).toList();
        metaDataFields.keySet().removeIf(key -> key.startsWith("contacts:"));
        IntStream.range(0, contactPersons.size()).forEach(i -> {
            Map contactPerson = (Map)contactPersons.get(i);
            Map.of("type", "contactType", "email", "emailAddress", "givenName", "givenName", "surName", "surName").forEach((k, v) -> this.putIf(metaDataFields, "contacts:" + i + ":" + v, contactPerson.get(k)));
        });
    }

    public List<ChangeRequest> deduceChangeRequests(Connection connection, Map<String, Object> currentProvider, Map<String, Object> auditData) {
        Map clonedProvider = this.deepClone(currentProvider);
        Map newProvider = this.convert(connection, clonedProvider, false);
        Map newData = ManageData.getData((Map)newProvider);
        Map currentData = ManageData.getData(currentProvider);
        ArrayList<ChangeRequest> changeRequests = new ArrayList<ChangeRequest>();
        LinkedHashMap pathUpdates = new LinkedHashMap();
        this.diffChangeRequestRecursive("", (Object)currentData, (Object)newData, pathUpdates);
        if (!pathUpdates.isEmpty()) {
            ChangeRequest changeRequest = new ChangeRequest(connection.getManageIdentifier(), connection.getProtocol(), pathUpdates, auditData, false, null, RequestType.Change);
            changeRequests.add(changeRequest);
        }
        return changeRequests;
    }

    public Map<String, Object> convertProviderToApplicationMetaData(Map<String, Object> provider) {
        Map metaDataFields = ManageData.getMetaDataFields((Map)ManageData.getData(provider));
        HashMap<String, Object> updatedMetaData = new HashMap<String, Object>();
        updatedMetaData.put("privacy", this.privacyInfo.stream().collect(Collectors.toMap(m -> m.get("name"), m -> metaDataFields.getOrDefault(m.get("manage"), ""))));
        HashMap<String, ArrayList<Object>> information = new HashMap<String, ArrayList<Object>>();
        information.put("tags", metaDataFields.getOrDefault("application_tags", new ArrayList()));
        information.put("webSite", (ArrayList<Object>)metaDataFields.get("coin:application_url"));
        information.put("descriptionEN", (ArrayList<Object>)metaDataFields.get("description:en"));
        information.put("descriptionNL", (ArrayList<Object>)metaDataFields.get("description:nl"));
        updatedMetaData.put("information", information);
        List<String> contactTypes = List.of("administrative", "technical", "support");
        List<Map> contactPersons = metaDataFields.entrySet().stream().filter(entry -> ((String)entry.getKey()).endsWith(":contactType") && contactTypes.contains((String)entry.getValue())).collect(Collectors.toMap(entry -> ((String)entry.getKey()).split(":")[1], entry -> (String)entry.getValue())).entrySet().stream().map(entry -> Map.of("type", entry.getValue(), "email", metaDataFields.getOrDefault("contacts:" + (String)entry.getKey() + ":emailAddress", ""), "surName", metaDataFields.getOrDefault("contacts:" + (String)entry.getKey() + ":surName", ""), "givenName", metaDataFields.getOrDefault("contacts:" + (String)entry.getKey() + ":givenName", ""))).toList();
        updatedMetaData.put("contactPersons", contactPersons);
        return updatedMetaData;
    }

    private Map deepClone(Map original) {
        return (Map)this.objectMapper.convertValue((Object)original, Map.class);
    }

    private void diffChangeRequestRecursive(String path, Object oldVal, Object newVal, Map<String, Object> pathUpdates) {
        if (Objects.equals(oldVal, newVal) || this.excludedAttributes.contains(path)) {
            return;
        }
        if (oldVal instanceof Map && newVal instanceof Map) {
            Map oldMap = (Map)oldVal;
            Map newMap = (Map)newVal;
            HashSet allKeys = new HashSet();
            allKeys.addAll(oldMap.keySet());
            allKeys.addAll(newMap.keySet());
            for (String key : allKeys) {
                String newPath;
                String string = newPath = path.isEmpty() ? key : path + "." + key;
                if (this.excludedMergeAttributesPaths.contains(newPath)) {
                    pathUpdates.put(path, newVal);
                    return;
                }
                this.diffChangeRequestRecursive(newPath, oldMap.get(key), newMap.get(key), pathUpdates);
            }
            return;
        }
        if (oldVal instanceof List && newVal instanceof List) {
            pathUpdates.put(path, newVal);
            return;
        }
        if (oldVal == null && newVal != null) {
            pathUpdates.put(path, newVal);
        } else if (oldVal != null && newVal == null) {
            pathUpdates.put(path, null);
        } else {
            pathUpdates.put(path, newVal);
        }
    }

    private void mergeAllowedEntities(Map<String, Object> data, Map<String, Object> connectionMetaData) {
        List allowedEntities = connectionMetaData.getOrDefault("allowedEntities", List.of());
        data.put("allowedEntities", allowedEntities.stream().map(entity -> Map.of("name", entity)).toList());
    }

    private void mergeAttributeReleasePolicies(Map<String, Object> connectionMetaData, Map<String, Object> data) {
        Map newArp = (Map)connectionMetaData.get("arp");
        Map arpFromManage = data.getOrDefault("arp", Map.of());
        Map existingArpAttributes = arpFromManage.getOrDefault("attributes", Map.of());
        Map newArpAttributes = newArp.getOrDefault("attributes", Map.of());
        existingArpAttributes.entrySet().stream().filter(entry -> this.excludedARPAttributes.contains(entry.getKey())).forEach(entry -> {
            if (!newArpAttributes.containsKey(entry.getKey())) {
                newArpAttributes.put((String)entry.getKey(), (List)entry.getValue());
            }
        });
        this.putIf(data, "arp", (Object)newArp);
    }

    private void putIf(Map<String, Object> result, String key, Object value) {
        if (value instanceof String && StringUtils.hasText((String)((String)value)) || value != null) {
            result.put(key, value);
        }
    }
}

