/*
 * Decompiled with CFR 0.152.
 */
package access.model;

import access.model.ApplicationMembership;
import access.model.Authority;
import access.model.NameHolder;
import access.model.Organization;
import access.model.User;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.Hibernate;

@Entity(name="organization_memberships")
public class OrganizationMembership
implements NameHolder {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="created_at")
    private Instant createdAt;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_id")
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private User user;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="organization_id")
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private Organization organization;
    @Enumerated(value=EnumType.STRING)
    @Column
    @NotNull
    private Authority authority = Authority.MEMBER;
    @OneToMany(mappedBy="organizationMembership", orphanRemoval=true, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Set<ApplicationMembership> applicationMemberships = new HashSet();
    @Transient
    private String transientName;

    public OrganizationMembership(Authority authority) {
        this.authority = authority;
    }

    public OrganizationMembership(User user, Organization organization, Authority authority) {
        this.user = user;
        this.organization = organization;
        this.authority = authority;
        this.transientName = this.getClass().getName().concat(organization.getName()).concat(authority.name());
        this.createdAt = Instant.now();
    }

    @JsonIgnore
    public ApplicationMembership addApplicationMembership(ApplicationMembership applicationMemberships) {
        this.applicationMemberships.add(applicationMemberships);
        return applicationMemberships;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY, value="organization")
    public Map<String, Serializable> getOrganizationInfo() {
        Organization organization = this.getOrganization();
        HashMap<String, Serializable> organizationInfo = new HashMap<String, Serializable>();
        if (organization != null && Hibernate.isInitialized((Object)organization)) {
            organizationInfo.put("id", organization.getId());
            organizationInfo.put("name", (Serializable)((Object)organization.getName()));
            organizationInfo.put("status", (Serializable)organization.getStatus());
            organizationInfo.put("schacHomeOrganization", (Serializable)((Object)organization.getSchacHomeOrganization()));
        }
        return organizationInfo;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY, value="user")
    public Map<String, Serializable> getUserInfo() {
        User user = this.getUser();
        HashMap<String, Serializable> userInfo = new HashMap<String, Serializable>();
        if (user != null && Hibernate.isInitialized((Object)user)) {
            userInfo.put("id", user.getId());
            userInfo.put("name", (Serializable)((Object)user.getName()));
            userInfo.put("email", (Serializable)((Object)user.getEmail()));
            userInfo.put("schacHomeOrganization", (Serializable)((Object)user.getSchacHomeOrganization()));
        }
        return userInfo;
    }

    @JsonIgnore
    public void removeApplicationMembership(ApplicationMembership applicationMembership) {
        this.removeApplicationMemberships(List.of(applicationMembership));
    }

    @JsonIgnore
    public void removeApplicationMemberships(List<ApplicationMembership> applicationMemberships) {
        List<Long> applicationMembershipsIdentifiers = applicationMemberships.stream().map(am -> am.getId()).toList();
        Set newApplicationMemberships = this.applicationMemberships.stream().filter(am -> !applicationMembershipsIdentifiers.contains(am.getId())).collect(Collectors.toSet());
        this.applicationMemberships.clear();
        this.applicationMemberships.addAll(newApplicationMemberships);
    }

    @Transient
    @JsonIgnore
    public String getName() {
        return this.transientName;
    }

    @Generated
    public OrganizationMembership() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public User getUser() {
        return this.user;
    }

    @Generated
    public Organization getOrganization() {
        return this.organization;
    }

    @Generated
    public Authority getAuthority() {
        return this.authority;
    }

    @Generated
    public Set<ApplicationMembership> getApplicationMemberships() {
        return this.applicationMemberships;
    }

    @Generated
    public String getTransientName() {
        return this.transientName;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUser(User user) {
        this.user = user;
    }

    @Generated
    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    @Generated
    public void setAuthority(Authority authority) {
        this.authority = authority;
    }

    @Generated
    public void setApplicationMemberships(Set<ApplicationMembership> applicationMemberships) {
        this.applicationMemberships = applicationMemberships;
    }

    @Generated
    public void setTransientName(String transientName) {
        this.transientName = transientName;
    }
}

