/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.api.UserAccessRights;
import access.exception.NotFoundException;
import access.exception.UserRestrictionException;
import access.model.Application;
import access.model.Authority;
import access.model.Organization;
import access.model.OrganizationMembership;
import access.model.User;
import access.repository.UserRepository;
import java.util.Optional;

/*
 * Exception performing whole class analysis ignored.
 */
public interface UserAccessRights {
    default public void confirmOrganizationMembership(User user, Organization organization, Authority authority) {
        if (user.isSuperUser()) {
            return;
        }
        UserAccessRights.getOrganizationMembership((User)user, (Organization)organization, (Authority)authority).orElseThrow(() -> new UserRestrictionException(String.format("User %s is not a member of organization %s", user.getEmail(), organization.getName())));
    }

    default public void confirmApplicationWriteAccess(User user, Application application) {
        if (user.isSuperUser()) {
            return;
        }
        Organization organization = application.getOrganization();
        OrganizationMembership organizationMembership = (OrganizationMembership)UserAccessRights.getOrganizationMembership((User)user, (Organization)organization, (Authority)Authority.GUEST).orElseThrow(() -> new UserRestrictionException(String.format("User %s is not a member of organization %s", user.getEmail(), organization.getName())));
        boolean allowed = switch (1.$SwitchMap$access$model$Authority[organizationMembership.getAuthority().ordinal()]) {
            default -> throw new MatchException(null, null);
            case 1 -> true;
            case 2, 3 -> {
                boolean allowedByApplicationMembership = organizationMembership.getApplicationMemberships().stream().anyMatch(applicationMembership -> applicationMembership.getApplication().getId().equals(application.getId()));
                if (application.getOwner() != null && application.getOwner().getId().equals(user.getId()) || allowedByApplicationMembership) {
                    yield true;
                }
                yield false;
            }
        };
        if (!allowed) {
            throw new UserRestrictionException(String.format("User %s is not allowed to access application %s", user.getEmail(), application.getName()));
        }
    }

    default public void confirmApplicationDeleteAccess(User user, Application application) {
        boolean allowed;
        if (user.isSuperUser()) {
            return;
        }
        Organization organization = application.getOrganization();
        OrganizationMembership organizationMembership = (OrganizationMembership)UserAccessRights.getOrganizationMembership((User)user, (Organization)organization, (Authority)Authority.MEMBER).orElseThrow(() -> new UserRestrictionException(String.format("User %s is not a member of organization %s", user.getEmail(), organization.getName())));
        switch (1.$SwitchMap$access$model$Authority[organizationMembership.getAuthority().ordinal()]) {
            default: {
                throw new MatchException(null, null);
            }
            case 1: {
                boolean bl = true;
                break;
            }
            case 2: {
                boolean bl;
                if (application.getOwner() != null && application.getOwner().getId().equals(user.getId())) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                boolean bl = allowed = false;
            }
        }
        if (!allowed) {
            throw new UserRestrictionException(String.format("User %s is not allowed to access application %s", user.getEmail(), application.getName()));
        }
    }

    private static Optional<OrganizationMembership> getOrganizationMembership(User user, Organization organization, Authority authority) {
        return user.getOrganizationMemberships().stream().filter(orgMembership -> orgMembership.getOrganization().getId().equals(organization.getId())).filter(orgMembership -> orgMembership.getAuthority().isAllowed(authority)).findFirst();
    }

    default public User reinitializeUser(User user, UserRepository userRepository) {
        return (User)userRepository.findById((Object)user.getId()).orElseThrow(() -> new NotFoundException("User not found"));
    }

    default public void confirmSuperUser(User user) {
        if (!user.isSuperUser()) {
            throw new UserRestrictionException(String.format("User %s is no super user", user.getEmail()));
        }
    }
}

