/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.api.Results;
import access.api.UserAccessRights;
import access.config.HashGenerator;
import access.exception.NotAllowedException;
import access.exception.NotFoundException;
import access.mail.MailBox;
import access.model.AcceptInvitation;
import access.model.Application;
import access.model.ApplicationMembership;
import access.model.Authority;
import access.model.Invitation;
import access.model.InvitationForm;
import access.model.Organization;
import access.model.OrganizationMembership;
import access.model.User;
import access.repository.ApplicationRepository;
import access.repository.InvitationRepository;
import access.repository.OrganizationMembershipRepository;
import access.repository.OrganizationRepository;
import access.repository.UserRepository;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/invitations"}, produces={"application/json"})
@Transactional
@SecurityRequirements(value={@SecurityRequirement(name="openId", scopes={"openid"}), @SecurityRequirement(name="apiTokens")})
public class InvitationController
implements UserAccessRights {
    private static final Log LOG = LogFactory.getLog(InvitationController.class);
    private final InvitationRepository invitationRepository;
    private final OrganizationRepository organizationRepository;
    private final ApplicationRepository applicationRepository;
    private final MailBox mailBox;
    private final UserRepository userRepository;
    private final OrganizationMembershipRepository organizationMembershipRepository;

    public InvitationController(InvitationRepository invitationRepository, OrganizationRepository organizationRepository, ApplicationRepository applicationRepository, MailBox mailBox, UserRepository userRepository, OrganizationMembershipRepository organizationMembershipRepository) {
        this.invitationRepository = invitationRepository;
        this.organizationRepository = organizationRepository;
        this.applicationRepository = applicationRepository;
        this.mailBox = mailBox;
        this.userRepository = userRepository;
        this.organizationMembershipRepository = organizationMembershipRepository;
    }

    @GetMapping(value={"/all/{organizationId}"})
    public ResponseEntity<List<Invitation>> byOrganization(User user, @PathVariable(value="organizationId") Long organizationId) {
        LOG.debug((Object)("/by organization by " + user.getEmail()));
        Organization organization = (Organization)this.organizationRepository.findById((Object)organizationId).orElseThrow(() -> new NotFoundException("Organization not found"));
        this.confirmOrganizationMembership(user, organization, Authority.ADMIN);
        List invitations = this.invitationRepository.findByOrganization(organization);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)invitations);
    }

    @GetMapping(value={"/hash"})
    public ResponseEntity<Invitation> byHash(User user, @RequestParam(value="hash") String hash) {
        LOG.debug((Object)("/by hash by " + user.getEmail()));
        Invitation invitation = (Invitation)this.invitationRepository.findDetailsByHash(hash).orElseThrow(() -> new NotFoundException("Invitation not found"));
        return ResponseEntity.ok((Object)invitation);
    }

    @PostMapping(value={"", "/"})
    public ResponseEntity<Map<String, Object>> create(User user, @RequestBody InvitationForm invitationForm) {
        LOG.debug((Object)("/create invitation by " + user.getEmail()));
        Long organizationID = invitationForm.getOrganizationId();
        Organization organization = (Organization)this.organizationRepository.findById((Object)organizationID).orElseThrow(() -> new NotFoundException("Organization not found"));
        Authority requiredAuthority = invitationForm.getIntendedAuthority().equals((Object)Authority.ADMIN) ? Authority.ADMIN : Authority.MEMBER;
        this.confirmOrganizationMembership(user, organization, requiredAuthority);
        Set applications = invitationForm.getApplicationIdentifiers().stream().map(applicationId -> (Application)this.applicationRepository.findById(applicationId).orElseThrow(() -> new NotFoundException("Application not found"))).collect(Collectors.toSet());
        if (!applications.stream().allMatch(application -> application.getOrganization().getId().equals(organizationID))) {
            throw new NotAllowedException("Not allowed to add applications outside the organization");
        }
        invitationForm.getInvites().forEach(invitee -> {
            Invitation invitation = new Invitation(invitationForm.getLanguage(), HashGenerator.generateRandomHash(), invitee, invitationForm.getMessage(), invitationForm.getIntendedAuthority(), organization, user, applications);
            invitation = (Invitation)this.invitationRepository.save((Object)invitation);
            this.mailBox.sendInviteMail(invitation);
        });
        return Results.createResult();
    }

    @PutMapping(value={"/accept"})
    public ResponseEntity<Map<String, Object>> accept(User user, @Validated @RequestBody AcceptInvitation acceptInvitation) {
        LOG.debug((Object)("/accept invitation by " + user.getEmail()));
        Invitation invitation = (Invitation)this.invitationRepository.findByIdAndHash(acceptInvitation.invitationId(), acceptInvitation.hash()).orElseThrow(() -> new NotFoundException("Invitation not found"));
        invitation.accept();
        user = this.reinitializeUser(user, this.userRepository);
        this.invitationRepository.save((Object)invitation);
        Organization organization = invitation.getOrganization();
        Optional<OrganizationMembership> organizationMembershipOptional = user.getOrganizationMemberships().stream().filter(organizationMembership -> organizationMembership.getOrganization().getId().equals(organization.getId())).findFirst();
        if (organizationMembershipOptional.isEmpty()) {
            OrganizationMembership organizationMembership2 = new OrganizationMembership(user, organization, invitation.getIntendedAuthority());
            List<ApplicationMembership> applicationMemberships = invitation.getApplications().stream().map(application -> new ApplicationMembership(application, organizationMembership2)).toList();
            applicationMemberships.forEach(arg_0 -> ((OrganizationMembership)organizationMembership2).addApplicationMembership(arg_0));
            organization.addOrganizationMembership(organizationMembership2);
            this.organizationRepository.save((Object)organization);
        } else {
            OrganizationMembership organizationMembership3 = organizationMembershipOptional.get();
            List<Long> applicationIdentifiers = organizationMembership3.getApplicationMemberships().stream().map(applicationMembership -> applicationMembership.getApplication().getId()).toList();
            List<ApplicationMembership> applicationMemberships = invitation.getApplications().stream().filter(application -> !applicationIdentifiers.contains(application.getId())).map(application -> new ApplicationMembership(application, organizationMembership3)).toList();
            applicationMemberships.forEach(arg_0 -> ((OrganizationMembership)organizationMembership3).addApplicationMembership(arg_0));
            this.organizationMembershipRepository.save((Object)organizationMembership3);
        }
        return Results.createResult();
    }

    @DeleteMapping(value={"/{invitationId}"})
    public ResponseEntity<Map<String, Object>> deleteInvitation(User user, @PathVariable(value="invitationId") Long invitationId) {
        LOG.debug((Object)("/delete invitation by " + user.getEmail()));
        Invitation invitation = (Invitation)this.invitationRepository.findById((Object)invitationId).orElseThrow(() -> new NotFoundException("Invitation not found"));
        Organization organization = invitation.getOrganization();
        Authority requiredAuthority = invitation.getIntendedAuthority().equals((Object)Authority.ADMIN) ? Authority.ADMIN : Authority.MEMBER;
        this.confirmOrganizationMembership(user, organization, requiredAuthority);
        this.invitationRepository.delete((Object)invitation);
        return Results.deleteResult();
    }

    @DeleteMapping(value={"/delete/all/{organizationId}"})
    public ResponseEntity<Map<String, Object>> deleteAll(User user, @PathVariable(value="organizationId") Long organizationId) {
        LOG.debug((Object)("/delete all invitation by " + user.getEmail()));
        Organization organization = (Organization)this.organizationRepository.findById((Object)organizationId).orElseThrow(() -> new NotFoundException("Organization not found"));
        this.confirmOrganizationMembership(user, organization, Authority.ADMIN);
        Set invitations = organization.getInvitations();
        organization.getInvitations().clear();
        this.invitationRepository.deleteAll((Iterable)invitations);
        return Results.deleteResult();
    }

    @PutMapping(value={"/resend/{invitationId}"})
    public ResponseEntity<Map<String, Object>> resendInvitation(User user, @PathVariable(value="invitationId") Long invitationId) {
        LOG.debug((Object)("/resend invitation by " + user.getEmail()));
        Invitation invitation = (Invitation)this.invitationRepository.findById((Object)invitationId).orElseThrow(() -> new NotFoundException("Invitation not found"));
        Organization organization = invitation.getOrganization();
        Authority requiredAuthority = invitation.getIntendedAuthority().equals((Object)Authority.ADMIN) ? Authority.ADMIN : Authority.MEMBER;
        this.confirmOrganizationMembership(user, organization, requiredAuthority);
        invitation.setExpiryDate(Instant.now().plus(30L, ChronoUnit.DAYS));
        this.invitationRepository.save((Object)invitation);
        this.mailBox.sendInviteMail(invitation);
        return Results.okResult();
    }
}

