/*
 * Decompiled with CFR 0.152.
 */
package access.security;

import access.manage.Manage;
import access.model.Environment;
import access.model.Institution;
import access.model.User;
import access.repository.UserRepository;
import access.security.InstitutionAdmin;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.util.StringUtils;

public class CustomOidcUserService
implements OAuth2UserService<OidcUserRequest, OidcUser> {
    private static final Log LOG = LogFactory.getLog(CustomOidcUserService.class);
    private final UserRepository userRepository;
    private final OidcUserService delegate;
    private final Manage manage;
    private final String entitlement;
    private final String organizationGuidPrefix;

    public CustomOidcUserService(UserRepository userRepository, Manage manage, String entitlement, String organizationGuidPrefix) {
        this.userRepository = userRepository;
        this.manage = manage;
        this.entitlement = entitlement;
        this.organizationGuidPrefix = organizationGuidPrefix;
        this.delegate = new OidcUserService();
    }

    public OidcUser loadUser(OidcUserRequest userRequest) throws OAuth2AuthenticationException {
        OidcUser oidcUser = this.delegate.loadUser(userRequest);
        Map claims = oidcUser.getUserInfo().getClaims();
        HashMap<String, Object> newClaims = new HashMap<String, Object>(claims);
        String sub = (String)newClaims.get("sub");
        Optional optionalUser = this.userRepository.findBySubIgnoreCase(sub);
        boolean institutionAdmin = InstitutionAdmin.isInstitutionAdmin((Map)claims, (String)this.entitlement) || optionalUser.isPresent() && InstitutionAdmin.isInstitutionAdmin((User)((User)optionalUser.get()));
        newClaims.put("INSTITUTION_ADMIN", institutionAdmin);
        String organizationGuid = institutionAdmin ? (String)InstitutionAdmin.getOrganizationGuid((Map)claims, (String)this.organizationGuidPrefix, (Optional)optionalUser).orElse(null) : null;
        newClaims.put("ORGANIZATION_GUID", organizationGuid);
        if (institutionAdmin && StringUtils.hasText((String)organizationGuid)) {
            String authenticatingAuthority = (String)claims.get("authenticating_authority");
            List identityProviders = this.manage.identityProvidersByInstitutionalGUID(Environment.PROD, organizationGuid);
            Optional<Map> optionalIdentityProvider = identityProviders.isEmpty() ? Optional.empty() : Optional.of(identityProviders.stream().filter(idp -> this.entityID(idp).equals(authenticatingAuthority)).findFirst().orElse((Map)identityProviders.getFirst()));
            optionalIdentityProvider.ifPresent(provider -> newClaims.put("INSTITUTION", new Institution(provider)));
        }
        optionalUser.ifPresent(user -> {
            boolean changed = user.updateAttributes(newClaims);
            if (changed) {
                LOG.debug((Object)("Updating user with new attributes: " + String.valueOf(newClaims)));
                this.userRepository.save(user);
            }
        });
        OidcUserInfo oidcUserInfo = new OidcUserInfo(newClaims);
        oidcUser = new DefaultOidcUser(oidcUser.getAuthorities(), oidcUser.getIdToken(), oidcUserInfo);
        return oidcUser;
    }

    private String entityID(Map<String, Object> provider) {
        Map data = (Map)provider.get("data");
        return (String)data.get("entityid");
    }

    @Generated
    public UserRepository getUserRepository() {
        return this.userRepository;
    }
}

