/*
 * Decompiled with CFR 0.152.
 */
package access.mail;

import access.model.Authority;
import access.model.Invitation;
import access.model.JoinRequest;
import access.model.Language;
import access.model.Organization;
import access.model.User;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.MustacheFactory;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.io.ClassPathResource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.util.StringUtils;

public class MailBox {
    private final JavaMailSender mailSender;
    private final String clientUrl;
    private final String emailFrom;
    private final String serviceDeskEmail;
    private final String supportEmail;
    private final String environment;
    private final Map<String, Map<String, String>> subjects;
    private final MustacheFactory mustacheFactory = new DefaultMustacheFactory("templates");

    public MailBox(JavaMailSender mailSender, String emailFrom, String serviceDeskEmail, String supportEmail, String clientUrl, String environment, ObjectMapper objectMapper) throws IOException {
        this.mailSender = mailSender;
        this.emailFrom = emailFrom;
        this.serviceDeskEmail = serviceDeskEmail;
        this.supportEmail = supportEmail;
        this.clientUrl = clientUrl;
        this.environment = environment;
        this.subjects = (Map)objectMapper.readValue(new ClassPathResource("/templates/subjects.json").getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void sendInviteMail(Invitation invitation) {
        Language language = invitation.getLanguage();
        String title = String.format((String)((Map)this.subjects.get(language.name())).get("newInvitation"), invitation.getOrganization().getName());
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("invitation", invitation);
        variables.put("title", title);
        if (StringUtils.hasText((String)invitation.getMessage())) {
            variables.put("message", invitation.getMessage().replaceAll("\n", "<br/>"));
        }
        if (!this.environment.equalsIgnoreCase("prod")) {
            variables.put("environment", this.environment);
        }
        variables.put("url", String.format("%s/accept?hash=%s", this.clientUrl, invitation.getHash()));
        this.sendMail(String.format("invitation_%s", language.name()), title, variables, new String[]{invitation.getEmail()});
    }

    public void sendConnectionRequest(User requester, List<User> recipients, Organization organization, String serviceProviderName, String message, String deepLink) {
        Language language = Language.valueOf((String)this.preferredLanguage());
        String title = String.format((String)((Map)this.subjects.get(language.name())).get("connectionRequest"), serviceProviderName);
        HashMap<String, String> variables = new HashMap<String, String>();
        if (StringUtils.hasText((String)message)) {
            variables.put("message", message.replaceAll("\n", "<br/>"));
        }
        variables.put("title", title);
        variables.put("serviceProviderName", serviceProviderName);
        variables.put("organization", (String)organization);
        variables.put("requester", (String)requester);
        variables.put("deepLink", String.format("%s%s", this.clientUrl, deepLink));
        if (!this.environment.equalsIgnoreCase("prod")) {
            variables.put("environment", this.environment);
        }
        this.sendMail(String.format("connection_request_%s", language.name()), title, variables, recipients.stream().map(user -> user.getEmail()).toList().toArray(new String[0]));
    }

    public void sendNewConnectionCreated(User institutionAdmin, List<String> recipients, String identityProviderName, String serviceProviderName, String serviceProviderEntityId) {
        Language language = Language.valueOf((String)this.preferredLanguage());
        String title = String.format((String)((Map)this.subjects.get(language.name())).get("newConnectionMade"), serviceProviderName, identityProviderName);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("title", title);
        variables.put("identityProviderName", identityProviderName);
        variables.put("serviceProviderName", serviceProviderName);
        variables.put("serviceProviderEntityId", serviceProviderEntityId);
        variables.put("institutionAdmin", (String)institutionAdmin);
        if (!this.environment.equalsIgnoreCase("prod")) {
            variables.put("environment", this.environment);
        }
        this.sendMail(String.format("new_connection_made_%s", language.name()), title, variables, recipients.toArray(new String[0]));
    }

    public void sendJoinRequestMail(JoinRequest joinRequest) {
        Language language = joinRequest.getLanguage();
        Organization organization = joinRequest.getOrganization();
        String title = String.format((String)((Map)this.subjects.get(language.name())).get("newJoinRequest"), joinRequest.getUser().getName(), organization.getName());
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("joinRequest", joinRequest);
        variables.put("title", title);
        if (!this.environment.equalsIgnoreCase("prod")) {
            variables.put("environment", this.environment);
        }
        variables.put("url", String.format("%s/organization/%s/joins", this.clientUrl, organization.getId()));
        List<String> emails = organization.getOrganizationMemberships().stream().filter(organizationMembership -> organizationMembership.getAuthority().equals((Object)Authority.ADMIN)).map(organizationMembership -> organizationMembership.getUser().getEmail()).toList();
        this.sendMail(String.format("join_request_%s", language.name()), title, variables, emails.toArray(new String[0]));
    }

    public void sendJoinRequestAcceptedMail(JoinRequest joinRequest) {
        Language language = joinRequest.getLanguage();
        Organization organization = joinRequest.getOrganization();
        String title = String.format((String)((Map)this.subjects.get(language.name())).get("acceptJoinRequest"), organization.getName());
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("joinRequest", joinRequest);
        variables.put("title", title);
        if (!this.environment.equalsIgnoreCase("prod")) {
            variables.put("environment", this.environment);
        }
        variables.put("url", String.format("%s/organization/%s/applications", this.clientUrl, organization.getId()));
        this.sendMail(String.format("join_request_accepted_%s", language.name()), title, variables, new String[]{joinRequest.getUser().getEmail()});
    }

    public void sendJoinRequestDeniedMail(JoinRequest joinRequest) {
        Language language = joinRequest.getLanguage();
        Organization organization = joinRequest.getOrganization();
        String title = String.format((String)((Map)this.subjects.get(language.name())).get("deniedJoinRequest"), organization.getName());
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("joinRequest", joinRequest);
        variables.put("title", title);
        if (!this.environment.equalsIgnoreCase("prod")) {
            variables.put("environment", this.environment);
        }
        this.sendMail(String.format("join_request_denied_%s", language.name()), title, variables, new String[]{joinRequest.getUser().getEmail()});
    }

    public void sendFeedbackMail(User user, String message) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("user", user);
        variables.put("title", "SURF Access feedback form");
        String now = LocalDate.now().format(DateTimeFormatter.ofPattern("dd-MM-yyyy"));
        variables.put("date", now);
        variables.put("message", message.replaceAll("\n", "<br/>"));
        if (!this.environment.equalsIgnoreCase("prod")) {
            variables.put("environment", this.environment);
        }
        variables.put("env", this.environment);
        this.sendMail("feedback_en", "Feedback", variables, new String[]{this.supportEmail});
    }

    private String preferredLanguage() {
        return LocaleContextHolder.getLocale().getLanguage();
    }

    private String sendMail(String templateName, String subject, Map<String, Object> variables, String ... to) throws MessagingException, IOException {
        String htmlText = this.mailTemplate(templateName + ".html", variables);
        String plainText = this.mailTemplate(templateName + ".txt", variables);
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        helper.setSubject(subject);
        helper.setText(plainText, htmlText);
        helper.setTo(to);
        helper.setFrom(this.emailFrom);
        new Thread(() -> this.mailSender.send(message)).start();
        return htmlText;
    }

    private String mailTemplate(String templateName, Map<String, Object> context) {
        return this.mustacheFactory.compile(templateName).execute((Writer)new StringWriter(), context).toString();
    }
}

