/*
 * Decompiled with CFR 0.152.
 */
package access.model;

import access.model.Institution;
import access.model.JoinRequest;
import access.model.NameHolder;
import access.model.OrganizationMembership;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.util.StringUtils;

@Entity(name="users")
public class User
implements Serializable,
NameHolder {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column
    @NotNull
    private String sub;
    @Column(name="super_user")
    @NotNull
    private boolean superUser;
    @Column(name="eduperson_principal_name")
    private String eduPersonPrincipalName;
    @Column(name="given_name")
    private String givenName;
    @Column(name="family_name")
    private String familyName;
    @Column(name="name")
    private String name;
    @Column(name="subject_id")
    private String subjectId;
    @Column(name="eduid")
    private String eduId;
    @Column(name="uid")
    private String uid;
    @Column(name="schac_home_organization")
    private String schacHomeOrganization;
    @Column(name="authenticating_authority")
    private String authenticatingAuthority;
    @Column
    private String email;
    @Column(name="created_at")
    private Instant createdAt;
    @Column(name="last_activity")
    private Instant lastActivity;
    @Column(name="organization_guid")
    private String organizationGUID;
    @Column(name="institution_admin")
    @NotNull
    private boolean institutionAdmin;
    @OneToMany(mappedBy="user", orphanRemoval=true, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private Set<OrganizationMembership> organizationMemberships = new HashSet();
    @OneToMany(mappedBy="user", orphanRemoval=true, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private Set<JoinRequest> joinRequests = new HashSet();
    @Transient
    private Institution institution = null;
    @Transient
    private Map<String, Object> identityProvider = null;
    @Transient
    private List<Map<String, Object>> changeRequests = null;
    @Transient
    private int loaLevel = 1;
    @Transient
    private boolean externalUser;

    public User(Map<String, Object> attributes) {
        this(false, attributes);
    }

    public User(boolean superUser, Map<String, Object> attributes) {
        this.superUser = superUser;
        this.sub = (String)attributes.get("sub");
        this.eduPersonPrincipalName = (String)attributes.get("eduperson_principal_name");
        this.schacHomeOrganization = (String)attributes.get("schac_home_organization");
        this.authenticatingAuthority = (String)attributes.get("authenticating_authority");
        this.email = (String)attributes.get("email");
        this.givenName = (String)attributes.get("given_name");
        this.familyName = (String)attributes.get("family_name");
        this.subjectId = (String)attributes.get("subject_id");
        this.eduId = (String)attributes.get("eduid");
        this.uid = attributes.getOrDefault("uids", List.of()).stream().findAny().orElse(null);
        this.lastActivity = this.createdAt = Instant.now();
        this.institutionAdmin = (Boolean)attributes.getOrDefault("INSTITUTION_ADMIN", false);
        this.organizationGUID = (String)attributes.get("ORGANIZATION_GUID");
        this.institution = (Institution)attributes.get("INSTITUTION");
        if (!StringUtils.hasText((String)this.eduPersonPrincipalName)) {
            this.eduPersonPrincipalName = this.email;
        }
        this.nameInvariant(attributes);
    }

    private void nameInvariant(Map<String, Object> attributes) {
        String name = (String)attributes.get("name");
        String preferredUsername = (String)attributes.get("preferred_username");
        if (StringUtils.hasText((String)name)) {
            this.name = name;
        } else if (StringUtils.hasText((String)preferredUsername)) {
            this.name = preferredUsername;
        } else if (StringUtils.hasText((String)this.givenName) && StringUtils.hasText((String)this.familyName)) {
            this.name = this.givenName + " " + this.familyName;
        } else if (StringUtils.hasText((String)this.email) && this.email.contains("@")) {
            this.name = Stream.of(this.email.substring(0, this.email.indexOf("@")).toLowerCase().split("\\.")).map(StringUtils::capitalize).collect(Collectors.joining(" "));
        } else if (StringUtils.hasText((String)this.sub)) {
            this.name = StringUtils.capitalize((String)this.sub.substring(this.sub.lastIndexOf(":") + 1));
        }
        this.nameInvariant();
    }

    public void nameInvariant() {
        if (!StringUtils.hasText((String)this.givenName) && !StringUtils.hasText((String)this.familyName) && StringUtils.hasText((String)this.name) && this.name.contains(" ")) {
            List<String> names = Arrays.asList(this.name.split(" "));
            this.givenName = names.get(0);
            this.familyName = String.join((CharSequence)" ", names.stream().skip(1L).toList());
        }
    }

    public User(boolean superUser, String eppn, String sub, String schacHomeOrganization, String givenName, String familyName, String email) {
        this.superUser = superUser;
        this.eduPersonPrincipalName = eppn;
        this.sub = sub;
        this.schacHomeOrganization = schacHomeOrganization;
        this.givenName = givenName;
        this.familyName = familyName;
        this.name = String.format("%s %s", givenName, familyName);
        this.email = email;
        this.createdAt = Instant.now();
        this.lastActivity = Instant.now();
    }

    @JsonIgnore
    public void updateAttributes(Map<String, Object> attributes) {
        this.eduPersonPrincipalName = (String)attributes.get("eduperson_principal_name");
        this.schacHomeOrganization = (String)attributes.get("schac_home_organization");
        this.givenName = (String)attributes.get("given_name");
        this.familyName = (String)attributes.get("family_name");
        this.authenticatingAuthority = (String)attributes.get("authenticating_authority");
        this.email = (String)attributes.get("email");
        this.subjectId = (String)attributes.get("subject_id");
        this.institutionAdmin = (Boolean)attributes.getOrDefault("INSTITUTION_ADMIN", false);
        this.organizationGUID = (String)attributes.get("ORGANIZATION_GUID");
        this.eduId = (String)attributes.get("eduid");
        this.lastActivity = Instant.now();
        this.nameInvariant(attributes);
        if (!StringUtils.hasText((String)this.eduPersonPrincipalName)) {
            this.eduPersonPrincipalName = this.email;
        }
    }

    @JsonIgnore
    public OrganizationMembership addOrganizationMembership(OrganizationMembership organizationMembership) {
        this.organizationMemberships.add(organizationMembership);
        organizationMembership.setUser(this);
        return organizationMembership;
    }

    @JsonProperty
    public Institution getInstitution() {
        return this.institution;
    }

    @JsonProperty
    public Map<String, Object> getIdentityProvider() {
        return this.identityProvider;
    }

    @JsonProperty
    public int getLoaLevel() {
        return this.loaLevel;
    }

    @JsonProperty
    public boolean isExternalUser() {
        return this.externalUser;
    }

    @JsonProperty
    public List<Map<String, Object>> getChangeRequests() {
        return this.changeRequests;
    }

    @Generated
    public User() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getSub() {
        return this.sub;
    }

    @Generated
    public boolean isSuperUser() {
        return this.superUser;
    }

    @Generated
    public String getEduPersonPrincipalName() {
        return this.eduPersonPrincipalName;
    }

    @Generated
    public String getGivenName() {
        return this.givenName;
    }

    @Generated
    public String getFamilyName() {
        return this.familyName;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getSubjectId() {
        return this.subjectId;
    }

    @Generated
    public String getEduId() {
        return this.eduId;
    }

    @Generated
    public String getUid() {
        return this.uid;
    }

    @Generated
    public String getSchacHomeOrganization() {
        return this.schacHomeOrganization;
    }

    @Generated
    public String getAuthenticatingAuthority() {
        return this.authenticatingAuthority;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Instant getLastActivity() {
        return this.lastActivity;
    }

    @Generated
    public String getOrganizationGUID() {
        return this.organizationGUID;
    }

    @Generated
    public boolean isInstitutionAdmin() {
        return this.institutionAdmin;
    }

    @Generated
    public Set<OrganizationMembership> getOrganizationMemberships() {
        return this.organizationMemberships;
    }

    @Generated
    public Set<JoinRequest> getJoinRequests() {
        return this.joinRequests;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setSub(String sub) {
        this.sub = sub;
    }

    @Generated
    public void setSuperUser(boolean superUser) {
        this.superUser = superUser;
    }

    @Generated
    public void setEduPersonPrincipalName(String eduPersonPrincipalName) {
        this.eduPersonPrincipalName = eduPersonPrincipalName;
    }

    @Generated
    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    @Generated
    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setSubjectId(String subjectId) {
        this.subjectId = subjectId;
    }

    @Generated
    public void setEduId(String eduId) {
        this.eduId = eduId;
    }

    @Generated
    public void setUid(String uid) {
        this.uid = uid;
    }

    @Generated
    public void setSchacHomeOrganization(String schacHomeOrganization) {
        this.schacHomeOrganization = schacHomeOrganization;
    }

    @Generated
    public void setAuthenticatingAuthority(String authenticatingAuthority) {
        this.authenticatingAuthority = authenticatingAuthority;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setLastActivity(Instant lastActivity) {
        this.lastActivity = lastActivity;
    }

    @Generated
    public void setOrganizationGUID(String organizationGUID) {
        this.organizationGUID = organizationGUID;
    }

    @Generated
    public void setInstitutionAdmin(boolean institutionAdmin) {
        this.institutionAdmin = institutionAdmin;
    }

    @Generated
    public void setOrganizationMemberships(Set<OrganizationMembership> organizationMemberships) {
        this.organizationMemberships = organizationMemberships;
    }

    @Generated
    public void setJoinRequests(Set<JoinRequest> joinRequests) {
        this.joinRequests = joinRequests;
    }

    @Generated
    public void setInstitution(Institution institution) {
        this.institution = institution;
    }

    @Generated
    public void setIdentityProvider(Map<String, Object> identityProvider) {
        this.identityProvider = identityProvider;
    }

    @Generated
    public void setChangeRequests(List<Map<String, Object>> changeRequests) {
        this.changeRequests = changeRequests;
    }

    @Generated
    public void setLoaLevel(int loaLevel) {
        this.loaLevel = loaLevel;
    }

    @Generated
    public void setExternalUser(boolean externalUser) {
        this.externalUser = externalUser;
    }
}

