/*
 * Decompiled with CFR 0.152.
 */
package access.manage;

import access.manage.ConnectionProviderConverter;
import access.manage.LocalManage;
import access.manage.Manage;
import access.manage.ManageAuthorization;
import access.manage.RemoteManage;
import access.model.Environment;
import access.model.State;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ManageConf {
    @Bean
    public Manage manage(@Value(value="${manage.test.url}") String testUrl, @Value(value="${manage.test.user}") String testUser, @Value(value="${manage.test.password}") String testPassword, @Value(value="${manage.prod.url}") String prodUrl, @Value(value="${manage.prod.user}") String prodUser, @Value(value="${manage.prod.password}") String prodPassword, @Value(value="${manage.enabled}") boolean enabled, @Value(value="${manage.staticManageDirectory}") String staticManageDirectory, @Value(value="${manage.activeManage}") Environment activeEnvironment, ConnectionProviderConverter converter, ObjectMapper objectMapper) throws IOException {
        ManageAuthorization testAuthorization = new ManageAuthorization(testUrl, testUser, testPassword, Environment.TEST);
        ManageAuthorization prodAuthorization = new ManageAuthorization(prodUrl, prodUser, prodPassword, Environment.PROD);
        return enabled ? new RemoteManage(testAuthorization, prodAuthorization, converter, activeEnvironment, objectMapper) : new LocalManage(converter, objectMapper, staticManageDirectory);
    }

    @Bean
    public ConnectionProviderConverter connectionProviderConverter(@Value(value="${manage.test.defaultState}") State defaultTestState, @Value(value="${manage.prod.defaultState}") State defaultProdState, ObjectMapper objectMapper) {
        return new ConnectionProviderConverter(objectMapper, defaultTestState, defaultProdState);
    }
}

