/*
 * Decompiled with CFR 0.152.
 */
package access;

import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.OAuthFlows;
import io.swagger.v3.oas.models.security.Scopes;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.filter.ForwardedHeaderFilter;

@Configuration
@OpenAPIDefinition
public class SwaggerOpenIdConfig {
    public static final String OPEN_ID_SCHEME_NAME = "openId";
    public static final String API_TOKENS_SCHEME_NAME = "apiTokens";
    public static final String BASIC_AUTHENTICATION_SCHEME_NAME = "basic_auth";

    @Bean
    OpenAPI customOpenApi(@Value(value="${spring.security.oauth2.client.provider.oidcng.authorization-uri}") String authorizationUrl, @Value(value="${spring.security.oauth2.client.provider.oidcng.token-uri}") String tokenUrl, @Value(value="${oidcng.discovery-url}") String discoveryURL, @Value(value="${oidcng.base-url}") String baseUrl) {
        SecurityScheme openIdSecuritySchema = new SecurityScheme().type(SecurityScheme.Type.OAUTH2).openIdConnectUrl(discoveryURL).flows(new OAuthFlows().authorizationCode(new OAuthFlow().authorizationUrl(authorizationUrl).tokenUrl(tokenUrl).scopes(new Scopes().addString("openid", "openid"))));
        SecurityScheme apiTokensSecurityScheme = new SecurityScheme().type(SecurityScheme.Type.APIKEY).in(SecurityScheme.In.HEADER).name("X-API-TOKEN");
        SecurityScheme basicAuthentication = new SecurityScheme().type(SecurityScheme.Type.HTTP).scheme("basic");
        Components components = new Components().addSecuritySchemes(OPEN_ID_SCHEME_NAME, openIdSecuritySchema).addSecuritySchemes(API_TOKENS_SCHEME_NAME, apiTokensSecurityScheme).addSecuritySchemes(BASIC_AUTHENTICATION_SCHEME_NAME, basicAuthentication);
        OpenAPI openAPI = new OpenAPI().info(new Info().description("Access external API endpoints").title("Access API").version("v1")).addServersItem(new Server().url(baseUrl));
        openAPI.components(components).addSecurityItem(new SecurityRequirement().addList(OPEN_ID_SCHEME_NAME));
        return openAPI;
    }

    @Bean
    ForwardedHeaderFilter forwardedHeaderFilter() {
        return new ForwardedHeaderFilter();
    }
}

