/*
 * Decompiled with CFR 0.152.
 */
package access.repository;

import access.model.User;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
public interface UserRepository
extends JpaRepository<User, Long> {
    @EntityGraph(attributePaths={"joinRequests.organization", "organizationMemberships.organization", "organizationMemberships.applicationMemberships.application"})
    public Optional<User> findDetailsById(Long var1);

    public Optional<User> findBySubIgnoreCase(String var1);

    public List<User> findBySuperUser(boolean var1);

    @Query(value=" SELECT u.id, u.name, u.email, u.schac_home_organization, u.super_user, u.institution_admin,\n    u.created_at as createdAt, u.last_activity as lastActivity\n  FROM users u WHERE MATCH (given_name, family_name, email, schac_home_organization) against (?1  IN BOOLEAN MODE)\n", countQuery="SELECT count(*) FROM users WHERE MATCH (given_name, family_name, email, schac_home_organization) against (?1  IN BOOLEAN MODE)", nativeQuery=true)
    public Page<Map<String, Object>> searchByPageWithKeyword(String var1, Pageable var2);

    @Query(value=" SELECT u.id, u.name, u.email, u.schac_home_organization, u.super_user, u.institution_admin,\n    u.created_at as createdAt, u.last_activity as lastActivity\n  FROM users u\n", countQuery="SELECT count(*) FROM users", nativeQuery=true)
    public Page<Map<String, Object>> searchByPage(Pageable var1);
}

