/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.model.User;
import access.stats.Scale;
import access.stats.Statistics;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/stats"})
public class StatisticsController {
    private final Statistics statistics;

    @Autowired
    public StatisticsController(Statistics statistics) {
        this.statistics = statistics;
    }

    @GetMapping(value={"/loginTimeFrame"})
    public List<Object> loginTimeFrame(User user, @RequestParam(value="from") long from, @RequestParam(value="to") long to, @RequestParam(value="scale") Scale scale, @RequestParam(value="spEntityId", required=false) String spEntityId) {
        String authenticatingAuthority = user.getAuthenticatingAuthority();
        return this.statistics.loginTimeFrame(from, to, scale.name(), authenticatingAuthority, spEntityId);
    }

    @GetMapping(value={"/loginAggregated"})
    public List<Object> loginAggregated(User user, @RequestParam(value="period") String period, @RequestParam(value="spEntityId", required=false) String spEntityId) {
        String authenticatingAuthority = user.getAuthenticatingAuthority();
        return this.statistics.loginAggregated(period, authenticatingAuthority, spEntityId);
    }

    @GetMapping(value={"uniqueLoginCount"})
    public List<Object> uniqueLoginCount(User user, @RequestParam(value="from") long from, @RequestParam(value="to") long to, @RequestParam(value="spEntityId") String spEntityId) {
        String authenticatingAuthority = user.getAuthenticatingAuthority();
        return this.statistics.uniqueLoginCount(from, to, authenticatingAuthority, spEntityId);
    }
}

