/*
 * Decompiled with CFR 0.152.
 */
package access.model;

import access.model.Role;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.context.i18n.LocaleContextHolder;

public record GroupedProviders(Map<String, Object> provider, List<Role> roles, String logoName) {
    private final Map<String, Object> provider;
    private final List<Role> roles;
    private final String logoName;

    public GroupedProviders(Map<String, Object> provider, List<Role> roles, String logoName) {
        this.provider = provider;
        this.roles = roles;
        this.logoName = logoName;
    }

    public String getName() {
        return this.getAttribute("name:");
    }

    public String getOrganisation() {
        return this.getAttribute("OrganizationName:");
    }

    public String getRolesDisplay() {
        return this.roles.stream().map(role -> role.getName()).collect(Collectors.joining(", "));
    }

    public String getLogo() {
        return (String)this.provider.get("logo");
    }

    private String getAttribute(String name) {
        String[] languages = this.preferredLanguageWithFallback();
        return (String)this.provider.getOrDefault(name + languages[0], this.provider.get(name + languages[1]));
    }

    private String[] preferredLanguageWithFallback() {
        String language = LocaleContextHolder.getLocale().getLanguage();
        return new String[]{language, language.equals("en") ? "nl" : "en"};
    }

    public Map<String, Object> provider() {
        return this.provider;
    }

    public List<Role> roles() {
        return this.roles;
    }

    public String logoName() {
        return this.logoName;
    }
}

