/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.api.ApplicationResource;
import access.exception.InvalidInputException;
import access.model.Application;
import access.model.ApplicationUsage;
import access.model.Role;
import access.repository.ApplicationRepository;
import access.repository.ApplicationUsageRepository;
import access.validation.URLFormatValidator;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class RoleOperations {
    private final URLFormatValidator urlFormatValidator = new URLFormatValidator();
    private final ApplicationResource appRepositoryResource;

    public RoleOperations(ApplicationResource appRepositoryResource) {
        this.appRepositoryResource = appRepositoryResource;
    }

    public void assertValidRole(Role role) {
        if (CollectionUtils.isEmpty((Collection)role.getApplicationUsages())) {
            throw new InvalidInputException("applicationUsages are required");
        }
        role.getApplicationUsages().forEach(applicationUsage -> {
            if (StringUtils.hasText((String)applicationUsage.getLandingPage()) && !this.urlFormatValidator.isValid(applicationUsage.getLandingPage())) {
                throw new InvalidInputException("Valid landingPage is required");
            }
        });
    }

    public void syncRoleApplicationUsages(Role role) {
        ApplicationRepository applicationRepository = this.appRepositoryResource.getApplicationRepository();
        ApplicationUsageRepository applicationUsageRepository = this.appRepositoryResource.getApplicationUsageRepository();
        Set applicationUsages = role.getApplicationUsages().stream().map(applicationUsageFromClient -> {
            Application application = applicationUsageFromClient.getApplication();
            Application applicationFromDB = applicationRepository.findByManageIdAndManageType(application.getManageId(), application.getManageType()).orElseGet(() -> (Application)applicationRepository.save((Object)application));
            ApplicationUsage applicationUsageFromDB = applicationUsageRepository.findByRoleIdAndApplicationManageIdAndApplicationManageType(role.getId(), applicationFromDB.getManageId(), applicationFromDB.getManageType()).orElseGet(() -> new ApplicationUsage(applicationFromDB, applicationUsageFromClient.getLandingPage()));
            applicationUsageFromDB.setLandingPage(applicationUsageFromClient.getLandingPage());
            return applicationUsageFromDB;
        }).collect(Collectors.toSet());
        role.setApplicationUsages(applicationUsages);
    }
}

