/*
 * Decompiled with CFR 0.152.
 */
package db.mysql.migration;

import access.config.ObjectMapperHolder;
import access.manage.EntityType;
import access.model.Application;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Set;
import java.util.UUID;
import javax.sql.DataSource;
import org.flywaydb.core.api.migration.BaseJavaMigration;
import org.flywaydb.core.api.migration.Context;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;

public class V11_0__migrate_applications
extends BaseJavaMigration {
    public void migrate(Context context) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate((DataSource)new SingleConnectionDataSource(context.getConnection(), true));
        jdbcTemplate.query("SELECT id, manage_id, manage_type FROM roles", rs -> {
            String jsonNode;
            long roleId = rs.getLong("id");
            jdbcTemplate.update("UPDATE roles SET identifier = ? WHERE id = ?", new Object[]{UUID.randomUUID().toString(), roleId});
            String manageId = rs.getString("manage_id");
            String manageType = rs.getString("manage_type");
            Set<Application> applications = Set.of(new Application(manageId, EntityType.valueOf((String)manageType)));
            try {
                jsonNode = ObjectMapperHolder.objectMapper.writeValueAsString(applications);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            jdbcTemplate.update("UPDATE roles SET applications = ?", new Object[]{jsonNode});
        });
    }
}

