/*
 * Decompiled with CFR 0.152.
 */
package access.manage;

import access.exception.NotFoundException;
import access.manage.EntityType;
import access.manage.Manage;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.CollectionUtils;

public final class LocalManage
implements Manage {
    private static final Log LOG = LogFactory.getLog(LocalManage.class);
    private final Map<EntityType, List<Map<String, Object>>> allProviders;
    private final DefaultResourceLoader defaultResourceLoader = new DefaultResourceLoader();

    public LocalManage(ObjectMapper objectMapper) {
        this(objectMapper, "classpath:/manage");
    }

    public LocalManage(ObjectMapper objectMapper, String staticManageDirectory) {
        this.allProviders = Stream.of(EntityType.values()).collect(Collectors.toMap(entityType -> entityType, entityType -> this.initialize(objectMapper, entityType, staticManageDirectory)));
    }

    private List<Map<String, Object>> initialize(ObjectMapper objectMapper, EntityType entityType, String staticManageDirectory) {
        String resourceName = String.format("%s/%s.json", staticManageDirectory, entityType.collectionName());
        Resource resource = this.defaultResourceLoader.getResource(resourceName);
        return (List)objectMapper.readValue(resource.getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<Map<String, Object>> providers(EntityType ... entityTypes) {
        LOG.debug((Object)("providers for : " + String.valueOf(List.of(entityTypes))));
        return this.transformProvider(Stream.of(entityTypes).map(entityType -> ((List)this.allProviders.get(entityType)).stream().toList()).flatMap(Collection::stream).toList());
    }

    public List<Map<String, Object>> providersByIdIn(EntityType entityType, List<String> identifiers) {
        LOG.debug((Object)("providersByIdIn for : " + String.valueOf(entityType)));
        List providers = (List)this.allProviders.get(entityType);
        return this.transformProvider(providers.stream().filter(provider -> identifiers.contains(provider.get("_id"))).collect(Collectors.toList()));
    }

    public Optional<Map<String, Object>> providerByEntityID(EntityType entityType, String entityID) {
        LOG.debug((Object)("providerByEntityID for : " + String.valueOf(entityType)));
        return ((List)this.allProviders.get(entityType)).stream().filter(provider -> entityID.equals(((Map)provider.get("data")).get("entityid"))).map(arg_0 -> ((LocalManage)this).transformProvider(arg_0)).findFirst();
    }

    public Map<String, Object> providerById(EntityType entityType, String id) {
        LOG.debug((Object)("providerById for : " + String.valueOf(entityType)));
        List providers = this.providers(new EntityType[]{entityType});
        return providers.stream().filter(provider -> provider.get("_id").equals(id)).findFirst().orElseThrow(() -> new NotFoundException("Provider not found"));
    }

    public List<Map<String, Object>> provisioning(Collection<String> ids) {
        LOG.debug((Object)("provisioning for : " + String.valueOf(ids)));
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        return this.providers(new EntityType[]{EntityType.PROVISIONING}).stream().filter(map -> {
            List applications = (List)map.get("applications");
            return applications.stream().anyMatch(m -> ids.contains(m.get("id")));
        }).collect(Collectors.toList());
    }

    public List<Map<String, Object>> providersAllowedByIdP(Map<String, Object> identityProvider) {
        LOG.debug((Object)("providersAllowedByIdP for : " + String.valueOf(identityProvider.get("type"))));
        Boolean allowedAll = (Boolean)identityProvider.getOrDefault("allowedall", Boolean.FALSE);
        List allProviders = this.providers(new EntityType[]{EntityType.SAML20_SP, EntityType.OIDC10_RP});
        if (allowedAll.booleanValue()) {
            return allProviders;
        }
        List allowedEntities = identityProvider.getOrDefault("allowedEntities", Collections.emptyList());
        List<String> entityIdentifiers = allowedEntities.stream().map(m -> (String)m.get("name")).toList();
        return allProviders.stream().filter(provider -> entityIdentifiers.contains((String)provider.get("entityid"))).toList();
    }

    public Optional<Map<String, Object>> identityProviderByInstitutionalGUID(String organisationGUID) {
        LOG.debug((Object)("identityProviderByInstitutionalGUID for : " + organisationGUID));
        List providers = this.providers(new EntityType[]{EntityType.SAML20_IDP});
        return providers.stream().filter(provider -> Objects.equals(provider.get("institutionGuid"), organisationGUID)).findAny();
    }
}

