/*
 * Decompiled with CFR 0.152.
 */
package access.provision.eva;

import access.model.User;
import access.provision.Provisioning;
import access.provision.eva.EvaClient;
import access.provision.eva.GuestAccount;
import access.repository.RemoteProvisionedUserRepository;
import crypto.KeyStore;
import java.net.URI;
import java.util.Optional;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.util.MultiValueMap;

public class EvaClient {
    private final KeyStore keyStore;
    private final RemoteProvisionedUserRepository remoteProvisionedUserRepository;

    public EvaClient(KeyStore keyStore, RemoteProvisionedUserRepository remoteProvisionedUserRepository) {
        this.keyStore = keyStore;
        this.remoteProvisionedUserRepository = remoteProvisionedUserRepository;
    }

    public RequestEntity<String> newUserRequest(Provisioning provisioning, User user) {
        return this.doEvaRequest(provisioning, user, "/api/v1/guest/create", RequestType.create);
    }

    public RequestEntity updateUserRequest(Provisioning provisioning, User user) {
        return this.doEvaRequest(provisioning, user, "/api/v1/guest/create", RequestType.update);
    }

    public RequestEntity deleteUserRequest(Provisioning provisioning, User user) {
        return this.remoteProvisionedUserRepository.findByManageProvisioningIdAndUser(provisioning.getId(), user).map(remoteProvisionedUser -> {
            String path = "/api/v1/guest/disable/" + remoteProvisionedUser.getRemoteIdentifier();
            this.remoteProvisionedUserRepository.delete(remoteProvisionedUser);
            return this.doEvaRequest(provisioning, user, path, RequestType.delete);
        }).orElse(null);
    }

    private RequestEntity doEvaRequest(Provisioning provisioning, User user, String path, RequestType requestType) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        String encryptedEvaToken = provisioning.getEvaToken();
        String evaToken = this.keyStore.isEncryptedSecret(encryptedEvaToken) ? this.keyStore.decodeAndDecrypt(encryptedEvaToken) : encryptedEvaToken;
        headers.add("X-Api-Key", evaToken);
        String url = provisioning.getEvaUrl() + path;
        if (requestType.equals((Object)RequestType.delete)) {
            return new RequestEntity((MultiValueMap)headers, HttpMethod.POST, URI.create(url));
        }
        MultiValueMap map = new GuestAccount(user, provisioning).getRequest();
        if (requestType.equals((Object)RequestType.update)) {
            Optional optionalRemoteProvisionedUser = this.remoteProvisionedUserRepository.findByManageProvisioningIdAndUser(provisioning.getId(), user);
            optionalRemoteProvisionedUser.ifPresent(remoteProvisionedUser -> map.add((Object)"id", (Object)remoteProvisionedUser.getRemoteIdentifier()));
        }
        return new RequestEntity((Object)map, (MultiValueMap)headers, HttpMethod.POST, URI.create(url));
    }
}

