/*
 * Decompiled with CFR 0.152.
 */
package access.manage;

import access.manage.EntityType;
import access.manage.Manage;
import access.manage.ResilientErrorHandler;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class RemoteManage
implements Manage {
    private static final Log LOG = LogFactory.getLog(RemoteManage.class);
    private final String url;
    private final RestTemplate restTemplate = new RestTemplate();
    private final Map<String, Object> queries;

    public RemoteManage(String url, String user, String password, ObjectMapper objectMapper) throws IOException {
        this.url = url;
        this.queries = (Map)objectMapper.readValue(new ClassPathResource("/manage/query_templates.json").getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        this.restTemplate.getInterceptors().add(new BasicAuthenticationInterceptor(user, password));
        ResilientErrorHandler resilientErrorHandler = new ResilientErrorHandler();
        this.restTemplate.setErrorHandler((ResponseErrorHandler)resilientErrorHandler);
    }

    public List<Map<String, Object>> providers(EntityType ... entityTypes) {
        LOG.debug((Object)("Providers for entityTypes: " + String.valueOf(List.of(entityTypes))));
        return Stream.of(entityTypes).map(entityType -> this.getRemoteMetaData(entityType.collectionName())).flatMap(Collection::stream).toList();
    }

    public List<Map<String, Object>> providersByIdIn(EntityType entityType, List<String> identifiers) {
        LOG.debug((Object)("providersByIdIn: " + String.valueOf(entityType)));
        if (CollectionUtils.isEmpty(identifiers)) {
            return Collections.emptyList();
        }
        String param = identifiers.stream().map(id -> String.format("\"%s\"", id)).collect(Collectors.joining(","));
        String body = String.format("{ \"id\": { \"$in\": [%s]}}", param);
        String manageUrl = String.format("%s/manage/api/internal/rawSearch/%s", this.url, entityType.collectionName());
        List providers = (List)this.restTemplate.postForObject(manageUrl, (Object)body, List.class, new Object[0]);
        return this.transformProvider(providers);
    }

    public Optional<Map<String, Object>> providerByEntityID(EntityType entityType, String entityID) {
        LOG.debug((Object)("providerByEntityID: " + String.valueOf(entityType)));
        String body = String.format("{\"data.entityid\":\"%s\"}", entityID);
        String manageUrl = String.format("%s/manage/api/internal/rawSearch/%s", this.url, entityType.collectionName());
        List providers = (List)this.restTemplate.postForObject(manageUrl, (Object)body, List.class, new Object[0]);
        List allProviders = this.transformProvider(providers);
        return allProviders.isEmpty() ? Optional.empty() : Optional.of((Map)allProviders.get(0));
    }

    public Map<String, Object> providerById(EntityType entityType, String id) {
        LOG.debug((Object)("providerById: " + String.valueOf(entityType)));
        String queryUrl = String.format("%s/manage/api/internal/metadata/%s/%s", this.url, entityType.collectionName(), id);
        return this.transformProvider((Map)this.restTemplate.getForEntity(queryUrl, Map.class, new Object[0]).getBody());
    }

    public List<Map<String, Object>> provisioning(Collection<String> applicationIdentifiers) {
        LOG.debug((Object)"provisionings for identifiers");
        if (CollectionUtils.isEmpty(applicationIdentifiers)) {
            return Collections.emptyList();
        }
        String queryUrl = String.format("%s/manage/api/internal/provisioning", this.url);
        return this.transformProvider((List)this.restTemplate.postForObject(queryUrl, applicationIdentifiers, List.class, new Object[0]));
    }

    public List<Map<String, Object>> providersAllowedByIdP(Map<String, Object> identityProvider) {
        LOG.debug((Object)("providersAllowedByIdP for : " + String.valueOf(identityProvider.get("type"))));
        Boolean allowedAll = (Boolean)identityProvider.getOrDefault("allowedall", Boolean.FALSE);
        if (allowedAll.booleanValue()) {
            return this.providers(new EntityType[]{EntityType.SAML20_SP, EntityType.OIDC10_RP});
        }
        List allowedEntities = identityProvider.getOrDefault("allowedEntities", Collections.emptyList());
        String split = allowedEntities.stream().map(m -> "\"" + (String)m.get("name") + "\"").collect(Collectors.joining(","));
        String body = String.format("{\"data.entityid\":{\"$in\":[%s]}}", split);
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        List.of(EntityType.SAML20_SP, EntityType.OIDC10_RP).forEach(entityType -> {
            String manageUrl = String.format("%s/manage/api/internal/rawSearch/%s", this.url, entityType.collectionName());
            List providers = (List)this.restTemplate.postForObject(manageUrl, (Object)body, List.class, new Object[0]);
            List transformedProviders = this.transformProvider(providers);
            results.addAll(transformedProviders);
        });
        return results;
    }

    public Optional<Map<String, Object>> identityProviderByInstitutionalGUID(String organisationGUID) {
        LOG.debug((Object)("identityProviderByInstitutionalGUID for : " + organisationGUID));
        Map baseQuery = this.getBaseQuery();
        baseQuery.put("metaDataFields.coin:institution_guid", organisationGUID);
        List requestedAttributes = (List)baseQuery.get("REQUESTED_ATTRIBUTES");
        requestedAttributes.add("allowedEntities");
        requestedAttributes.add("allowedall");
        List identityProviders = (List)this.restTemplate.postForObject(String.format("%s/manage/api/internal/search/%s", this.url, EntityType.SAML20_IDP.collectionName()), (Object)baseQuery, List.class, new Object[0]);
        return identityProviders.isEmpty() ? Optional.empty() : Optional.of(this.transformProvider((Map)identityProviders.get(0)));
    }

    private List<Map<String, Object>> getRemoteMetaData(String type) {
        Map baseQuery = this.getBaseQuery();
        String url = String.format("%s/manage/api/internal/search/%s", this.url, type);
        return this.transformProvider((List)this.restTemplate.postForObject(url, (Object)baseQuery, List.class, new Object[0]));
    }

    private Map<String, Object> getBaseQuery() {
        HashMap<String, Object> baseQuery = new HashMap<String, Object>((Map)this.queries.get("base_query"));
        baseQuery.put("REQUESTED_ATTRIBUTES", baseQuery.get("REQUESTED_ATTRIBUTES"));
        return baseQuery;
    }
}

