/*
 * Decompiled with CFR 0.152.
 */
package access.manage;

import access.manage.EntityType;
import access.manage.ManageIdentifier;
import access.model.GroupedProviders;
import access.model.Role;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public interface Manage {
    public List<Map<String, Object>> providers(EntityType ... var1);

    public Map<String, Object> providerById(EntityType var1, String var2);

    public Optional<Map<String, Object>> providerByEntityID(EntityType var1, String var2);

    public List<Map<String, Object>> providersByIdIn(EntityType var1, List<String> var2);

    public List<Map<String, Object>> provisioning(Collection<String> var1);

    public List<Map<String, Object>> providersAllowedByIdP(Map<String, Object> var1);

    public Optional<Map<String, Object>> identityProviderByInstitutionalGUID(String var1);

    default public List<Map<String, Object>> transformProvider(List<Map<String, Object>> providers) {
        if (CollectionUtils.isEmpty(providers)) {
            return new ArrayList<Map<String, Object>>();
        }
        return providers.stream().map(arg_0 -> this.transformProvider(arg_0)).toList();
    }

    default public Map<String, Object> transformProvider(Map<String, Object> provider) {
        if (CollectionUtils.isEmpty(provider)) {
            return new HashMap<String, Object>();
        }
        Map data = (Map)provider.get("data");
        if (CollectionUtils.isEmpty((Map)data)) {
            return provider;
        }
        Map metaDataFields = (Map)data.get("metaDataFields");
        HashMap<String, Object> application = new HashMap<String, Object>();
        Object id = provider.get("id");
        if (id != null) {
            application.put("id", id);
            application.put("_id", id);
        } else {
            Object underscoreId = provider.get("_id");
            application.put("id", underscoreId);
            application.put("_id", underscoreId);
        }
        if (provider.get("type").equals(EntityType.PROVISIONING.collectionName())) {
            List.of("provisioning_type", "scim_url", "scim_user", "scim_password", "scim_bearer_token", "scim_update_role_put_method", "scim_user_identifier", "eva_url", "eva_token", "eva_guest_account_duration", "graph_url", "graph_client_id", "graph_secret", "graph_tenant", "user_wait_time").forEach(attribute -> application.put((String)attribute, metaDataFields.get(attribute)));
        }
        application.put("type", provider.get("type"));
        application.put("applications", data.get("applications"));
        application.put("allowedEntities", data.get("allowedEntities"));
        application.put("allowedall", data.get("allowedall"));
        application.put("entityid", data.get("entityid"));
        application.put("logo", metaDataFields.get("logo:0:url"));
        application.put("url", metaDataFields.get("coin:application_url"));
        application.put("OrganizationName:en", metaDataFields.get("OrganizationName:en"));
        application.put("OrganizationName:nl", metaDataFields.get("OrganizationName:nl"));
        application.put("name:en", metaDataFields.get("name:en"));
        application.put("name:nl", metaDataFields.get("name:nl"));
        application.put("institutionGuid", metaDataFields.get("coin:institution_guid"));
        return application;
    }

    default public List<Role> addManageMetaData(List<Role> roles) {
        Map<EntityType, List<ManageIdentifier>> groupedManageIdentifiers = roles.stream().map(Role::applicationsUsed).flatMap(Collection::stream).map(application -> new ManageIdentifier(application.getManageId(), application.getManageType())).collect(Collectors.toSet()).stream().collect(Collectors.groupingBy(ManageIdentifier::manageType));
        Map<String, Map> remoteApplications = groupedManageIdentifiers.entrySet().stream().map(entry -> this.providersByIdIn((EntityType)entry.getKey(), ((List)entry.getValue()).stream().map(ManageIdentifier::manageId).toList())).flatMap(Collection::stream).collect(Collectors.toMap(map -> (String)map.get("id"), map -> map));
        roles.forEach(role -> role.setApplicationMaps(role.getApplicationUsages().stream().map(applicationUsage -> {
            HashMap<String, Object> applicationMap = this.transformProvider((Map)remoteApplications.get(applicationUsage.getApplication().getManageId()));
            if (CollectionUtils.isEmpty((Map)applicationMap)) {
                applicationMap = new HashMap<String, Object>();
                applicationMap.put("unknown", true);
            } else {
                applicationMap = new HashMap(applicationMap);
            }
            applicationMap.put("landingPage", applicationUsage.getLandingPage());
            return applicationMap;
        }).toList()));
        return roles;
    }

    default public List<GroupedProviders> getGroupedProviders(List<Role> requestedRoles) {
        return requestedRoles.stream().map(Role::applicationsUsed).flatMap(Collection::stream).map(application -> new ManageIdentifier(application.getManageId(), application.getManageType())).collect(Collectors.toSet()).stream().map(manageIdentifier -> this.providerById(manageIdentifier.manageType(), manageIdentifier.manageId())).filter(provider -> !CollectionUtils.isEmpty((Map)provider)).map(provider -> {
            String id = (String)provider.get("id");
            return new GroupedProviders(provider, requestedRoles.stream().filter(role -> role.applicationsUsed().stream().anyMatch(application -> application.getManageId().equals(id))).toList(), UUID.randomUUID().toString());
        }).toList();
    }

    default public Map<String, Object> enrichInstitutionAdmin(String organizationGUID) {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("INSTITUTION_ADMIN", true);
        claims.put("ORGANIZATION_GUID", organizationGUID);
        Optional optionalIdentityProvider = this.identityProviderByInstitutionalGUID(organizationGUID);
        claims.put("INSTITUTION", optionalIdentityProvider.orElse(null));
        List applications = optionalIdentityProvider.map(arg_0 -> this.providersAllowedByIdP(arg_0)).orElse(Collections.emptyList());
        claims.put("APPLICATIONS", applications);
        return claims;
    }
}

