/*
 * Decompiled with CFR 0.152.
 */
package access.model;

import access.manage.EntityType;
import access.model.ApplicationUsage;
import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;

@Entity(name="applications")
public class Application
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="manage_id")
    @NotNull
    private String manageId;
    @Column(name="manage_type")
    @Enumerated(value=EnumType.STRING)
    @NotNull
    private EntityType manageType;
    @Transient
    private String landingPage;
    @OneToMany(mappedBy="application", fetch=FetchType.LAZY, orphanRemoval=true)
    @JsonIgnore
    private Set<ApplicationUsage> applicationUsages = new HashSet();

    public Application(String manageId, EntityType manageType) {
        this(manageId, manageType, "https://landingpage.com");
    }

    public Application(String manageId, EntityType manageType, String landingPage) {
        this.manageId = manageId;
        this.manageType = manageType;
        this.landingPage = landingPage;
    }

    @Generated
    public Application() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getManageId() {
        return this.manageId;
    }

    @Generated
    public EntityType getManageType() {
        return this.manageType;
    }

    @Generated
    public String getLandingPage() {
        return this.landingPage;
    }

    @Generated
    public Set<ApplicationUsage> getApplicationUsages() {
        return this.applicationUsages;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setManageId(String manageId) {
        this.manageId = manageId;
    }

    @Generated
    public void setManageType(EntityType manageType) {
        this.manageType = manageType;
    }

    @Generated
    public void setLandingPage(String landingPage) {
        this.landingPage = landingPage;
    }

    @JsonIgnore
    @Generated
    public void setApplicationUsages(Set<ApplicationUsage> applicationUsages) {
        this.applicationUsages = applicationUsages;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Application)) {
            return false;
        }
        Application other = (Application)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$manageId = this.getManageId();
        String other$manageId = other.getManageId();
        if (this$manageId == null ? other$manageId != null : !this$manageId.equals(other$manageId)) {
            return false;
        }
        EntityType this$manageType = this.getManageType();
        EntityType other$manageType = other.getManageType();
        return !(this$manageType == null ? other$manageType != null : !this$manageType.equals(other$manageType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Application;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $manageId = this.getManageId();
        result = result * 59 + ($manageId == null ? 43 : $manageId.hashCode());
        EntityType $manageType = this.getManageType();
        result = result * 59 + ($manageType == null ? 43 : $manageType.hashCode());
        return result;
    }
}

