/*
 * Decompiled with CFR 0.152.
 */
package access.provision;

import access.manage.EntityType;
import access.manage.ManageIdentifier;
import access.provision.Provisioning;
import access.provision.ProvisioningType;
import access.provision.ScimUserIdentifier;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.util.StringUtils;

public class Provisioning {
    private final String id;
    private final String entityId;
    private final ProvisioningType provisioningType;
    private final String scimUrl;
    private final String scimUser;
    private final String scimPassword;
    private final String scimBearerToken;
    private final ScimUserIdentifier scimUserIdentifier;
    private final String evaToken;
    private final boolean scimUpdateRolePutMethod;
    private final boolean scimUserProvisioningOnly;
    private final String evaUrl;
    private final String graphUrl;
    private final String graphClientId;
    private final String graphSecret;
    private final String graphTenant;
    private final String institutionGUID;
    private final List<ManageIdentifier> remoteApplications;
    private final Integer userWaitTime;

    public Provisioning(Map<String, Object> provider) {
        this.id = (String)provider.get("id");
        this.entityId = (String)provider.get("entityid");
        this.provisioningType = ProvisioningType.valueOf((String)((String)provider.get("provisioning_type")));
        this.scimUrl = (String)provider.get("scim_url");
        this.scimUser = (String)provider.get("scim_user");
        this.scimPassword = (String)provider.get("scim_password");
        this.scimBearerToken = (String)provider.get("scim_bearer_token");
        String optionalScimUserIdentifier = (String)provider.get("scim_user_identifier");
        this.scimUserIdentifier = StringUtils.hasText((String)optionalScimUserIdentifier) ? ScimUserIdentifier.valueOf((String)optionalScimUserIdentifier) : ScimUserIdentifier.eduperson_principal_name;
        Object updateRolePutMethod = provider.get("scim_update_role_put_method");
        this.scimUpdateRolePutMethod = updateRolePutMethod != null && (Boolean)updateRolePutMethod != false;
        Object userProvisioningOnly = provider.get("scim_user_provisioning_only");
        this.scimUserProvisioningOnly = userProvisioningOnly != null && (Boolean)userProvisioningOnly != false;
        this.evaUrl = (String)provider.get("eva_url");
        this.evaToken = (String)provider.get("eva_token");
        this.graphUrl = (String)provider.get("graph_url");
        this.graphClientId = (String)provider.get("graph_client_id");
        this.graphSecret = (String)provider.get("graph_secret");
        this.graphTenant = (String)provider.getOrDefault("graph_tenant", "common");
        this.institutionGUID = (String)provider.get("institutionGuid");
        this.userWaitTime = (Integer)provider.get("user_wait_time");
        List applicationMaps = provider.getOrDefault("applications", Collections.emptyList());
        this.remoteApplications = applicationMaps.stream().map(m -> new ManageIdentifier((String)m.get("id"), EntityType.valueOf((String)((String)m.get("type")).toUpperCase()))).toList();
        this.invariant();
    }

    private void invariant() {
        switch (1.$SwitchMap$access$provision$ProvisioningType[this.provisioningType.ordinal()]) {
            case 1: {
                assert (this.evaUrl != null) : "evaUrl is null";
                assert (this.evaToken != null) : "evaToken is null";
                break;
            }
            case 2: {
                assert (this.scimUrl != null) : "scimUrl is null";
                if (this.scimBearerToken != null) break;
                assert (this.scimUser != null) : "scimUser is null";
                assert (this.scimPassword != null) : "scimPassword or scimBearerToken is null";
                break;
            }
            case 3: {
                assert (this.graphClientId != null) : "graphClientId is null";
                assert (this.graphSecret != null) : "graphSecret is null";
                break;
            }
        }
        switch (1.$SwitchMap$access$provision$ScimUserIdentifier[this.scimUserIdentifier.ordinal()]) {
            case 1: {
                assert (this.institutionGUID != null) : "institutionGUID is null";
                break;
            }
        }
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getEntityId() {
        return this.entityId;
    }

    @Generated
    public ProvisioningType getProvisioningType() {
        return this.provisioningType;
    }

    @Generated
    public String getScimUrl() {
        return this.scimUrl;
    }

    @Generated
    public String getScimUser() {
        return this.scimUser;
    }

    @Generated
    public String getScimPassword() {
        return this.scimPassword;
    }

    @Generated
    public String getScimBearerToken() {
        return this.scimBearerToken;
    }

    @Generated
    public ScimUserIdentifier getScimUserIdentifier() {
        return this.scimUserIdentifier;
    }

    @Generated
    public String getEvaToken() {
        return this.evaToken;
    }

    @Generated
    public boolean isScimUpdateRolePutMethod() {
        return this.scimUpdateRolePutMethod;
    }

    @Generated
    public boolean isScimUserProvisioningOnly() {
        return this.scimUserProvisioningOnly;
    }

    @Generated
    public String getEvaUrl() {
        return this.evaUrl;
    }

    @Generated
    public String getGraphUrl() {
        return this.graphUrl;
    }

    @Generated
    public String getGraphClientId() {
        return this.graphClientId;
    }

    @Generated
    public String getGraphSecret() {
        return this.graphSecret;
    }

    @Generated
    public String getGraphTenant() {
        return this.graphTenant;
    }

    @Generated
    public String getInstitutionGUID() {
        return this.institutionGUID;
    }

    @Generated
    public List<ManageIdentifier> getRemoteApplications() {
        return this.remoteApplications;
    }

    @Generated
    public Integer getUserWaitTime() {
        return this.userWaitTime;
    }
}

