/*
 * Decompiled with CFR 0.152.
 */
package access.logging;

import access.logging.Event;
import access.model.Invitation;
import access.model.InvitationRole;
import access.model.Provisionable;
import access.model.Role;
import access.model.User;
import access.model.UserRole;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.slf4j.MDC;

/*
 * Exception performing whole class analysis ignored.
 */
public class AccessLogger {
    private AccessLogger() {
    }

    public static void role(Log log, Event event, Provisionable provisionable, Role role) {
        MDC.setContextMap(Map.of("type", String.format("%s Role", event), "userId", provisionable.getName(), "applications", AccessLogger.applications((Role)role), "roleId", role.getId().toString()));
        log.info((Object)String.format("%s role %s", event, role.getName()));
    }

    private static String applications(Role role) {
        return role.applicationsUsed().stream().map(application -> String.format("%s %s", application.getManageType(), application.getManageId())).collect(Collectors.joining(", "));
    }

    public static void userRole(Log log, Event event, User user, UserRole userRole) {
        Role role = userRole.getRole();
        MDC.setContextMap(Map.of("type", String.format("%s UserRole", event), "userId", user.getSub(), "applications", AccessLogger.applications((Role)role), "roleId", role.getId().toString()));
        log.info((Object)String.format("%s userRole %s", event, role.getName()));
    }

    public static void invitation(Log log, Event event, Invitation invitation) {
        List<Role> roles = invitation.getRoles().stream().map(InvitationRole::getRole).toList();
        User inviter = invitation.getInviter();
        MDC.setContextMap(Map.of("type", String.format("%s Invitation", event), "userId", inviter != null ? inviter.getSub() : invitation.getRemoteApiUser(), "applications", roles.stream().map(AccessLogger::applications).collect(Collectors.joining(", ")), "roles", String.join((CharSequence)",", roles.stream().map(Role::getName).toList())));
        log.info((Object)String.format("%s invitation for %s", event, invitation.getEmail()));
    }

    public static void user(Log log, Event event, User user) {
        MDC.setContextMap(Map.of("type", String.format("%s User", event), "userId", user.getSub()));
        log.info((Object)String.format("%s user with sub %s", event, user.getSub()));
    }
}

